/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.x500.cert.X509CertificateBuilder;

public class KeyStoreUtils {
    public static void generateSelfSignedCertificate(String keyStoreFileName, String provider, char[] keyStorePassword, char[] keyStoreCertificatePassword, String keyAlias, String host) throws IOException, GeneralSecurityException {
        KeyPairGenerator keyGen = provider != null ? KeyPairGenerator.getInstance("RSA", provider) : KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048, new SecureRandom());
        KeyPair pair = keyGen.generateKeyPair();
        PrivateKey privkey = pair.getPrivate();
        X509CertificateBuilder builder = new X509CertificateBuilder();
        Date from = new Date();
        Date to = new Date(from.getTime() + 315360000000L);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        builder.setNotValidAfter(ZonedDateTime.ofInstant(Instant.ofEpochMilli(to.getTime()), TimeZone.getDefault().toZoneId()));
        builder.setNotValidBefore(ZonedDateTime.ofInstant(Instant.ofEpochMilli(from.getTime()), TimeZone.getDefault().toZoneId()));
        builder.setSerialNumber(sn);
        X500Principal owner = new X500Principal("CN=" + host);
        builder.setSubjectDn(owner);
        builder.setIssuerDn(owner);
        builder.setPublicKey(pair.getPublic());
        builder.setVersion(3);
        builder.setSignatureAlgorithmName("SHA256withRSA");
        builder.setSigningKey(privkey);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, keyStorePassword);
        Certificate[] chain = new X509Certificate[]{builder.build()};
        keyStore.setKeyEntry(keyAlias, pair.getPrivate(), keyStoreCertificatePassword != null ? keyStoreCertificatePassword : keyStorePassword, chain);
        try (FileOutputStream stream = new FileOutputStream(keyStoreFileName);){
            keyStore.store(stream, keyStorePassword);
        }
    }

    public static void generateEmptyKeyStore(String keyStoreFileName, char[] keyStorePassword) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, keyStorePassword);
        try (FileOutputStream stream = new FileOutputStream(keyStoreFileName);){
            keyStore.store(stream, keyStorePassword);
        }
    }

    public static KeyStore buildFilelessKeyStore(Provider[] providers, String providerName, String type) throws GeneralSecurityException, IOException {
        Provider provider = ProviderUtil.findProvider((Provider[])providers, (String)providerName, KeyStore.class, (String)type);
        KeyStore keyStore = KeyStore.getInstance(type, provider);
        keyStore.load(null, null);
        return keyStore;
    }
}

