package org.infinispan.server.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.infinispan.commons.util.OS;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.KeyStoreException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import javax.naming.NamingException;
import java.util.List;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.util.NoSuchElementException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.FATAL;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-11-20T08:06:09-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serverStarting(final String name, final String version) {
        super.log.logf(FQCN, INFO, null, serverStarting$str(), name, version);
    }
    protected String serverStarting$str() {
        return "ISPN080000: %s Server %s starting";
    }
    @Override
    public final void serverStarted(final String name, final String version, final long ms) {
        super.log.logf(FQCN, INFO, null, serverStarted$str(), name, version, ms);
    }
    protected String serverStarted$str() {
        return "ISPN080001: %s Server %s started in %dms";
    }
    @Override
    public final void serverStopping(final String name) {
        super.log.logf(FQCN, INFO, null, serverStopping$str(), name);
    }
    protected String serverStopping$str() {
        return "ISPN080002: %s Server stopping";
    }
    @Override
    public final void serverStopped(final String name) {
        super.log.logf(FQCN, INFO, null, serverStopped$str(), name);
    }
    protected String serverStopped$str() {
        return "ISPN080003: %s Server stopped";
    }
    @Override
    public final void protocolStarted(final String name, final String socketBinding, final String host, final int port) {
        super.log.logf(FQCN, INFO, null, protocolStarted4$str(), name, socketBinding, host, port);
    }
    protected String protocolStarted4$str() {
        return "ISPN080004: Connector %s (%s) listening on %s:%d";
    }
    protected String cannotInstantiateProtocolServerConfigurationBuilder$str() {
        return "ISPN080008: Cannot instantiate protocol server configuration '%s'";
    }
    @Override
    public final CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(final Class<?> klass, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotInstantiateProtocolServerConfigurationBuilder$str(), klass), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unknownInterface$str() {
        return "ISPN080009: Unknown interface '%s'";
    }
    @Override
    public final CacheConfigurationException unknownInterface(final String interfaceName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownInterface$str(), interfaceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownSocketBinding$str() {
        return "ISPN080010: Unknown socket binding '%s'";
    }
    @Override
    public final CacheConfigurationException unknownSocketBinding(final String value) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownSocketBinding$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownSecurityDomain$str() {
        return "ISPN080014: Unknown security domain '%s'";
    }
    @Override
    public final CacheConfigurationException unknownSecurityDomain(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownSecurityDomain$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadRealmPropertyFiles$str() {
        return "ISPN080015: Unable to load realm property files";
    }
    @Override
    public final CacheConfigurationException unableToLoadRealmPropertyFiles(final IOException e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToLoadRealmPropertyFiles$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultKeyManager$str() {
        return "ISPN080016: No default key manager available";
    }
    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultKeyManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void serverConfiguration(final String name) {
        super.log.logf(FQCN, INFO, null, serverConfiguration$str(), name);
    }
    protected String serverConfiguration$str() {
        return "ISPN080017: Server configuration: %s";
    }
    @Override
    public final void protocolStarted(final String name) {
        super.log.logf(FQCN, INFO, null, protocolStarted1$str(), name);
    }
    protected String protocolStarted1$str() {
        return "ISPN080018: Started connector %s (internal)";
    }
    protected String trustStoreWithoutServerIdentity$str() {
        return "ISPN080020: Cannot use a trust store without a server identity";
    }
    @Override
    public final CacheConfigurationException trustStoreWithoutServerIdentity() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), trustStoreWithoutServerIdentity$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationWithoutSecurityRealm$str() {
        return "ISPN080021: Authentication cannot be configured without a security realm";
    }
    @Override
    public final CacheConfigurationException authenticationWithoutSecurityRealm() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), authenticationWithoutSecurityRealm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConfigureProtocolEncryptionUnderSinglePort$str() {
        return "ISPN080022: Cannot configure protocol encryption under a single port endpoint. Use a dedicated socket binding.";
    }
    @Override
    public final CacheConfigurationException cannotConfigureProtocolEncryptionUnderSinglePort() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotConfigureProtocolEncryptionUnderSinglePort$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String protocolCannotUseSameSocketBindingAsEndpoint$str() {
        return "ISPN080023: Cannot configure a protocol with the same socket binding used by the endpoint. Use a dedicated socket binding.";
    }
    @Override
    public final CacheConfigurationException protocolCannotUseSameSocketBindingAsEndpoint() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), protocolCannotUseSameSocketBindingAsEndpoint$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidUrl$str() {
        return "ISPN080024: Invalid URL: '%s'";
    }
    @Override
    public final CacheConfigurationException invalidUrl(final String url) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidUrl$str(), url));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleEndpointsSameTypeFound$str() {
        return "ISPN080025: Cannot have multiple connectors of the same type: found [%s]";
    }
    @Override
    public final CacheConfigurationException multipleEndpointsSameTypeFound(final String names) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), multipleEndpointsSameTypeFound$str(), names));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unnamedFactoryClass(final String name) {
        super.log.logf(FQCN, WARN, null, unnamedFactoryClass$str(), name);
    }
    protected String unnamedFactoryClass$str() {
        return "ISPN080026: Extension factory '%s' is lacking a @NamedFactory annotation";
    }
    @Override
    public final void loadedExtension(final String name) {
        super.log.logf(FQCN, INFO, null, loadedExtension$str(), name);
    }
    protected String loadedExtension$str() {
        return "ISPN080027: Loaded extension '%s'";
    }
    @Override
    public final void serverFailedToStart(final String name, final Throwable t) {
        super.log.logf(FQCN, FATAL, t, serverFailedToStart$str(), name);
    }
    protected String serverFailedToStart$str() {
        return "ISPN080028: %s Server failed to start";
    }
    @Override
    public final void clusterShutdown() {
        super.log.logf(FQCN, INFO, null, clusterShutdown$str());
    }
    protected String clusterShutdown$str() {
        return "ISPN080029: Cluster shutdown";
    }
    @Override
    public final void clusteredTaskError(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, clusteredTaskError$str());
    }
    protected String clusteredTaskError$str() {
        return "ISPN080030: Clustered task error";
    }
    protected String unknownServerIdentity$str() {
        return "ISPN080031: Unknown server identity '%s'";
    }
    @Override
    public final IllegalArgumentException unknownServerIdentity(final String serverPrincipal) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownServerIdentity$str(), serverPrincipal));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void loggingConfiguration(final String absolutePath) {
        super.log.logf(FQCN, INFO, null, loggingConfiguration$str(), absolutePath);
    }
    protected String loggingConfiguration$str() {
        return "ISPN080032: Logging configuration: %s";
    }
    protected String invalidNetworkConfiguration$str() {
        return "ISPN080033: Cannot find a network address which matches the supplied configuration";
    }
    @Override
    public final CacheConfigurationException invalidNetworkConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidNetworkConfiguration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void endpointUrl(final Object name, final String proto, final String host, final int port) {
        super.log.logf(FQCN, INFO, null, endpointUrl$str(), name, proto, host, port);
    }
    protected String endpointUrl$str() {
        return "ISPN080034: Server '%s' listening on %s://%s:%d";
    }
    protected String unknownAppender$str() {
        return "ISPN080035: Unknown appender `%s`";
    }
    @Override
    public final IllegalArgumentException unknownAppender(final String appender) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownAppender$str(), appender));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidLevel$str() {
        return "ISPN080036: Invalid level `%s`";
    }
    @Override
    public final IllegalArgumentException invalidLevel(final String level) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidLevel$str(), level));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nameAlreadyBound$str() {
        return "ISPN080037: The name '%s' is already bound";
    }
    @Override
    public final NamingException nameAlreadyBound(final String name) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), nameAlreadyBound$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void dataSourceCreated(final String name, final String jndiName) {
        super.log.logf(FQCN, INFO, null, dataSourceCreated$str(), name, jndiName);
    }
    protected String dataSourceCreated$str() {
        return "ISPN080038: Created datasource '%s' bound to JNDI '%s'";
    }
    protected String invalidUnicodeSequence$str() {
        return "ISPN080039: Invalid Unicode sequence '%s'";
    }
    @Override
    public final IOException invalidUnicodeSequence(final String sequence, final NoSuchElementException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidUnicodeSequence$str(), sequence), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noRealmFoundInProperties$str() {
        return "ISPN080040: No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line";
    }
    @Override
    public final RealmUnavailableException noRealmFoundInProperties() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), noRealmFoundInProperties$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateDataSource$str() {
        return "ISPN080041: Duplicate data source '%s'";
    }
    @Override
    public final CacheConfigurationException duplicateDataSource(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateDataSource$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateJndiName$str() {
        return "ISPN080042: Duplicate JNDI name '%s'";
    }
    @Override
    public final CacheConfigurationException duplicateJndiName(final String jndiName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateJndiName$str(), jndiName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String serverReportUnavailable$str() {
        return "ISPN080043: Cannot generate the server report on %s";
    }
    @Override
    public final IllegalStateException serverReportUnavailable(final OS os) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverReportUnavailable$str(), os));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnHotRodLazyRetrievalDeprecated() {
        super.log.logf(FQCN, WARN, null, warnHotRodLazyRetrievalDeprecated$str());
    }
    protected String warnHotRodLazyRetrievalDeprecated$str() {
        return "ISPN080044: HotRod lazy-retrieval has been deprecated and will be removed in a future version with no direct replacement";
    }
    @Override
    public final void endpointSocketBindingOverride(final String name) {
        super.log.logf(FQCN, WARN, null, endpointSocketBindingOverride$str(), name);
    }
    protected String endpointSocketBindingOverride$str() {
        return "ISPN080045: Overriding existing endpoint on socket-binding '%s'";
    }
    protected String unknownCredentialStore$str() {
        return "ISPN080046: Unknown credential store '%s'";
    }
    @Override
    public final IllegalArgumentException unknownCredentialStore(final String store) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownCredentialStore$str(), store));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownCredential$str() {
        return "ISPN080047: Unknown credential '%s' in store '%s'";
    }
    @Override
    public final IllegalArgumentException unknownCredential(final String alias, final String store) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownCredential$str(), alias, store));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingCredentialStoreName$str() {
        return "ISPN080048: A credential store name is missing";
    }
    @Override
    public final IllegalArgumentException missingCredentialStoreName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingCredentialStoreName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unspecifiedCredentialAlias$str() {
        return "ISPN080049: A credential alias must be specified if the store doesn't contain a single alias";
    }
    @Override
    public final CacheConfigurationException unspecifiedCredentialAlias() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unspecifiedCredentialAlias$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotOverrideCredential$str() {
        return "ISPN080050: Credential reference in element '%s' would override value specified in attribute '%s'";
    }
    @Override
    public final CacheConfigurationException cannotOverrideCredential(final String element, final String attribute) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotOverrideCredential$str(), element, attribute));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingCredential$str() {
        return "ISPN080051: Element '%s' is missing a credential attribute '%s' or a credential reference";
    }
    @Override
    public final CacheConfigurationException missingCredential(final String element, final String attribute) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingCredential$str(), element, attribute));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedMechanism$str() {
        return "ISPN080052: The request authentication mechanism '%s' is not supported";
    }
    @Override
    public final SecurityException unsupportedMechanism(final String mechName) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unsupportedMechanism$str(), mechName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String encryptionWithoutSecurityRealm$str() {
        return "ISPN080053: Encryption cannot be configured without a security realm";
    }
    @Override
    public final CacheConfigurationException encryptionWithoutSecurityRealm() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), encryptionWithoutSecurityRealm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultTrustManager$str() {
        return "ISPN080054: No default trust manager available";
    }
    @Override
    public final CacheConfigurationException noDefaultTrustManager() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noDefaultTrustManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void connectorIpFilterSet(final String connector, final List<org.infinispan.server.core.transport.IpSubnetFilterRule> rules) {
        super.log.logf(FQCN, INFO, null, connectorIpFilterSet$str(), connector, rules);
    }
    protected String connectorIpFilterSet$str() {
        return "ISPN080055: Connector '%s': IP filter set: %s";
    }
    @Override
    public final void connectorIpFilterCleared(final String connector) {
        super.log.logf(FQCN, INFO, null, connectorIpFilterCleared$str(), connector);
    }
    protected String connectorIpFilterCleared$str() {
        return "ISPN080056: Connector '%s': IP filter cleared";
    }
    @Override
    public final void connectorStopped(final String connector) {
        super.log.logf(FQCN, INFO, null, connectorStopped$str(), connector);
    }
    protected String connectorStopped$str() {
        return "ISPN080057: Connector '%s': stopped";
    }
    @Override
    public final void connectorStarted(final String connector) {
        super.log.logf(FQCN, INFO, null, connectorStarted$str(), connector);
    }
    protected String connectorStarted$str() {
        return "ISPN080058: Connector '%s': started";
    }
    @Override
    public final void noScriptEngines() {
        super.log.logf(FQCN, WARN, null, noScriptEngines$str());
    }
    protected String noScriptEngines$str() {
        return "ISPN080059: No script engines are available";
    }
    @Override
    public final void sslTransport(final String value) {
        super.log.logf(FQCN, INFO, null, sslTransport$str(), value);
    }
    protected String sslTransport$str() {
        return "ISPN080060: SSL Transport using realm '%s`";
    }
    protected String noSSLContext$str() {
        return "ISPN080061: Realm '%s' does not provide an SSL context";
    }
    @Override
    public final IllegalStateException noSSLContext(final String realm) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSSLContext$str(), realm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateRealmType$str() {
        return "ISPN080062: Cannot add multiple realms of type '%s' to security realm '%s'";
    }
    @Override
    public final CacheConfigurationException duplicateRealmType(final String type, final String realm) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateRealmType$str(), type, realm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateRealm$str() {
        return "ISPN080063: Duplicate realm '%s'";
    }
    @Override
    public final CacheConfigurationException duplicateRealm(final String realmName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateRealm$str(), realmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownRealm$str() {
        return "ISPN080064: Unknown realm '%s'";
    }
    @Override
    public final CacheConfigurationException unknownRealm(final String realmName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownRealm$str(), realmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyStore$str() {
        return "ISPN080065: Invalid keystore '%s'";
    }
    @Override
    public final KeyStoreException invalidKeyStore(final String filename) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), invalidKeyStore$str(), filename));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String filelessKeyStoreRequiresType$str() {
        return "ISPN080066: KeyStore definitions without a path must specify a type.";
    }
    @Override
    public final CacheConfigurationException filelessKeyStoreRequiresType() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), filelessKeyStoreRequiresType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String respEndpointRequiresRealmWithPassword$str() {
        return "ISPN080067: The RESP endpoint requires a security realm which supports passwords.";
    }
    @Override
    public final CacheConfigurationException respEndpointRequiresRealmWithPassword() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), respEndpointRequiresRealmWithPassword$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongMaskedPasswordFormat$str() {
        return "ISPN080068: Wrong masked password format";
    }
    @Override
    public final CacheConfigurationException wrongMaskedPasswordFormat() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), wrongMaskedPasswordFormat$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String aliasNotInKeystore$str() {
        return "ISPN080069: Alias '%s' not in keystore '%s'";
    }
    @Override
    public final CacheConfigurationException aliasNotInKeystore(final String alias, final String keystore) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), aliasNotInKeystore$str(), alias, keystore));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authorizationWithoutAuthentication$str() {
        return "ISPN080070: The cache container requires authorization, but none of the connectors enable authentication";
    }
    @Override
    public final CacheConfigurationException authorizationWithoutAuthentication() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), authorizationWithoutAuthentication$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapDirectVerificationWithoutUserMapper$str() {
        return "ISPN080071: A user mapper must be configured in order to use LDAP direct verification";
    }
    @Override
    public final CacheConfigurationException ldapDirectVerificationWithoutUserMapper() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), ldapDirectVerificationWithoutUserMapper$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void jmxNoDefaultSecurityRealm() {
        super.log.logf(FQCN, WARN, null, jmxNoDefaultSecurityRealm$str());
    }
    protected String jmxNoDefaultSecurityRealm$str() {
        return "ISPN080072: JMX remoting enabled without a default security realm. All connections will be rejected.";
    }
    @Override
    public final void jmxAuthenticationError(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, jmxAuthenticationError$str());
    }
    protected String jmxAuthenticationError$str() {
        return "ISPN080073: JMX authentication error";
    }
}
