/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.state;

import io.netty.channel.group.ChannelMatcher;
import io.netty.handler.ipfilter.IpFilterRuleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.globalstate.ScopeFilter;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.Server;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.server.core.transport.CompositeChannelMatcher;
import org.infinispan.server.core.transport.IpFilterRuleChannelMatcher;
import org.infinispan.server.core.transport.IpSubnetFilterRule;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.server.state.SecurityActions;

public final class ServerStateManagerImpl
implements ServerStateManager {
    private static final String CONNECTOR_STATE_SCOPE = "connector-state";
    private static final String CONNECTOR_IPFILTER_SCOPE = "connector-ipfilter";
    private static final ScopedState IGNORED_CACHES_KEY = new ScopedState("ignored-caches", "ignored-caches");
    private final EmbeddedCacheManager cacheManager;
    private final Server server;
    private final Cache<ScopedState, Object> cache;
    private final IgnoredCaches ignored = new IgnoredCaches();
    private volatile boolean hasIgnores;

    public ServerStateManagerImpl(Server server, EmbeddedCacheManager cacheManager, GlobalConfigurationManager configurationManager) {
        this.server = server;
        this.cacheManager = cacheManager;
        this.cache = configurationManager.getStateCache();
    }

    public void start() {
        this.updateLocalIgnoredCaches((IgnoredCaches)this.cache.get((Object)IGNORED_CACHES_KEY));
        this.cache.addListener((Object)new IgnoredCachesListener(), (CacheEventFilter)new ScopeFilter(IGNORED_CACHES_KEY.getScope()), null);
        this.cache.addListener((Object)new ConnectorStateListener(), (CacheEventFilter)new ScopeFilter(CONNECTOR_STATE_SCOPE), null);
        this.cache.addListener((Object)new ConnectorIpFilterListener(), (CacheEventFilter)new ScopeFilter(CONNECTOR_IPFILTER_SCOPE), null);
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> unignoreCache(String cacheName) {
        SecurityActions.checkPermission(this.cacheManager, AuthorizationPermission.ADMIN);
        ServerStateManagerImpl serverStateManagerImpl = this;
        synchronized (serverStateManagerImpl) {
            this.ignored.caches.remove(cacheName);
            this.hasIgnores = !this.ignored.caches.isEmpty();
            return this.cache.putAsync((Object)IGNORED_CACHES_KEY, (Object)this.ignored).thenApply(r -> null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> ignoreCache(String cacheName) {
        SecurityActions.checkPermission(this.cacheManager, AuthorizationPermission.ADMIN);
        ServerStateManagerImpl serverStateManagerImpl = this;
        synchronized (serverStateManagerImpl) {
            this.ignored.caches.add(cacheName);
            this.hasIgnores = !this.ignored.caches.isEmpty();
            return this.cache.putAsync((Object)IGNORED_CACHES_KEY, (Object)this.ignored).thenApply(r -> null);
        }
    }

    public Set<String> getIgnoredCaches() {
        return Collections.unmodifiableSet(this.ignored.caches);
    }

    public boolean isCacheIgnored(String cacheName) {
        return this.hasIgnores && this.ignored.caches.contains(cacheName);
    }

    public CompletableFuture<Boolean> connectorStart(String name) {
        SecurityActions.checkPermission(this.cacheManager, AuthorizationPermission.ADMIN);
        return this.cache.removeAsync((Object)new ScopedState(CONNECTOR_STATE_SCOPE, name), (Object)true).thenApply(v -> null);
    }

    public CompletableFuture<Void> connectorStop(String name) {
        SecurityActions.checkPermission(this.cacheManager, AuthorizationPermission.ADMIN);
        return this.cache.putAsync((Object)new ScopedState(CONNECTOR_STATE_SCOPE, name), (Object)true).thenApply(v -> null);
    }

    public CompletableFuture<Boolean> connectorStatus(String name) {
        SecurityActions.checkPermission(this.cacheManager, AuthorizationPermission.ADMIN);
        return this.cache.containsKeyAsync((Object)new ScopedState(CONNECTOR_STATE_SCOPE, name)).thenApply(v -> v == false);
    }

    public CompletableFuture<Void> setConnectorIpFilterRule(String name, Collection<IpSubnetFilterRule> filterRule) {
        SecurityActions.checkPermission(this.cacheManager, AuthorizationPermission.ADMIN);
        IpFilterRules ipFilterRules = new IpFilterRules();
        filterRule.forEach(r -> ipFilterRules.rules.add(new IpFilterRule((IpSubnetFilterRule)r)));
        return this.cache.putAsync((Object)new ScopedState(CONNECTOR_IPFILTER_SCOPE, name), (Object)ipFilterRules).thenApply(v -> null);
    }

    public CompletableFuture<Void> clearConnectorIpFilterRules(String name) {
        SecurityActions.checkPermission(this.cacheManager, AuthorizationPermission.ADMIN);
        return this.cache.putAsync((Object)new ScopedState(CONNECTOR_IPFILTER_SCOPE, name), (Object)new IpFilterRules()).thenApply(v -> null);
    }

    public Json clientsReport() {
        return Json.object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalIgnoredCaches(IgnoredCaches ignored) {
        if (ignored != null) {
            ServerStateManagerImpl serverStateManagerImpl = this;
            synchronized (serverStateManagerImpl) {
                this.ignored.caches.clear();
                this.ignored.caches.addAll(ignored.caches);
                this.hasIgnores = !this.ignored.caches.isEmpty();
            }
        }
    }

    private CompletionStage<Void> updateIpFilters(String connector, Collection<IpFilterRule> rules) {
        ProtocolServer protocolServer = this.server.getProtocolServers().get(connector);
        if (rules.isEmpty()) {
            protocolServer.getConfiguration().ipFilter().rules(Collections.emptyList());
            Server.log.connectorIpFilterCleared(connector);
            return CompletableFutures.completedNull();
        }
        ArrayList<IpSubnetFilterRule> localRules = new ArrayList<IpSubnetFilterRule>(rules.size());
        for (IpFilterRule rule : rules) {
            localRules.add(new IpSubnetFilterRule(rule.cidr, IpFilterRuleType.valueOf((String)rule.type)));
        }
        protocolServer.getConfiguration().ipFilter().rules(localRules);
        Transport transport = this.getTransport(protocolServer);
        CompositeChannelMatcher matcher = new CompositeChannelMatcher(new ChannelMatcher[]{protocolServer.getChannelMatcher(), new IpFilterRuleChannelMatcher(localRules)});
        return transport.closeChannels((ChannelMatcher)matcher).thenApply(v -> {
            Server.log.connectorIpFilterSet(connector, localRules);
            return v;
        });
    }

    private Transport getTransport(ProtocolServer protocolServer) {
        Transport transport = protocolServer.getTransport();
        if (transport == null) {
            transport = protocolServer.getEnclosingProtocolServer().getTransport();
        }
        return transport;
    }

    @ProtoTypeId(value=5400)
    static final class IgnoredCaches {
        @ProtoField(number=1, collectionImplementation=HashSet.class)
        final Set<String> caches;

        IgnoredCaches() {
            this(ConcurrentHashMap.newKeySet());
        }

        @ProtoFactory
        IgnoredCaches(Set<String> caches) {
            this.caches = ConcurrentHashMap.newKeySet(caches.size());
            this.caches.addAll(caches);
        }

        public String toString() {
            return "IgnoredCaches" + String.valueOf(this.caches);
        }
    }

    @Listener(observation=Listener.Observation.POST, includeCurrentState=true, clustered=true)
    private final class IgnoredCachesListener {
        private IgnoredCachesListener() {
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<ScopedState, IgnoredCaches> e) {
            if (!e.isOriginLocal()) {
                ServerStateManagerImpl.this.updateLocalIgnoredCaches((IgnoredCaches)e.getValue());
            }
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<ScopedState, IgnoredCaches> e) {
            if (!e.isOriginLocal()) {
                ServerStateManagerImpl.this.updateLocalIgnoredCaches((IgnoredCaches)e.getValue());
            }
        }
    }

    @Listener(observation=Listener.Observation.POST, includeCurrentState=true, clustered=true)
    private final class ConnectorStateListener {
        private ConnectorStateListener() {
        }

        @CacheEntryCreated
        public CompletionStage<Void> created(CacheEntryCreatedEvent<ScopedState, Boolean> e) {
            String connector = ((ScopedState)e.getKey()).getName();
            ProtocolServer protocolServer = ServerStateManagerImpl.this.server.getProtocolServers().get(connector);
            protocolServer.getConfiguration().disable();
            Transport transport = ServerStateManagerImpl.this.getTransport(protocolServer);
            return transport.closeChannels(protocolServer.getChannelMatcher()).thenApply(v -> {
                Server.log.connectorStopped(connector);
                return v;
            });
        }

        @CacheEntryRemoved
        public void removed(CacheEntryRemovedEvent<ScopedState, Boolean> e) {
            String connector = ((ScopedState)e.getKey()).getName();
            ServerStateManagerImpl.this.server.getProtocolServers().get(connector).getConfiguration().enable();
            Server.log.connectorStarted(connector);
        }
    }

    @Listener(observation=Listener.Observation.POST, includeCurrentState=true, clustered=true)
    private final class ConnectorIpFilterListener {
        private ConnectorIpFilterListener() {
        }

        @CacheEntryCreated
        @CacheEntryModified
        public CompletionStage<Void> modified(CacheEntryEvent<ScopedState, IpFilterRules> e) {
            return ServerStateManagerImpl.this.updateIpFilters(((ScopedState)e.getKey()).getName(), ((IpFilterRules)e.getValue()).rules);
        }
    }

    @ProtoTypeId(value=5403)
    static final class IpFilterRules {
        @ProtoField(number=1, collectionImplementation=LinkedHashSet.class)
        final Set<IpFilterRule> rules;

        IpFilterRules() {
            this(new LinkedHashSet<IpFilterRule>());
        }

        @ProtoFactory
        IpFilterRules(Set<IpFilterRule> rules) {
            this.rules = new LinkedHashSet<IpFilterRule>(rules.size());
            this.rules.addAll(rules);
        }
    }

    @ProtoTypeId(value=5404)
    static final class IpFilterRule {
        @ProtoField(number=1)
        final String cidr;
        @ProtoField(number=2)
        final String type;

        @ProtoFactory
        IpFilterRule(String cidr, String type) {
            this.cidr = cidr;
            this.type = type;
        }

        IpFilterRule(IpSubnetFilterRule filterRule) {
            this(filterRule.cidr(), filterRule.ruleType().name());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IpFilterRule that = (IpFilterRule)o;
            return this.cidr.equals(that.cidr) && this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.cidr, this.type);
        }
    }
}

