/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.endpoint;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingsConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.EndpointsConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;

public class EndpointsConfigurationBuilder
implements Builder<EndpointsConfiguration> {
    private final AttributeSet attributes;
    private final ServerConfigurationBuilder server;
    private final Map<String, EndpointConfigurationBuilder> endpoints = new LinkedHashMap<String, EndpointConfigurationBuilder>(2);
    private EndpointConfigurationBuilder current;

    public EndpointsConfigurationBuilder(ServerConfigurationBuilder server) {
        this.server = server;
        this.attributes = EndpointsConfiguration.attributeDefinitionSet();
    }

    public EndpointsConfigurationBuilder socketBinding(String socketBinding) {
        this.attributes.attribute(EndpointsConfiguration.SOCKET_BINDING).set((Object)socketBinding);
        return this;
    }

    public EndpointsConfigurationBuilder securityRealm(String securityRealm) {
        this.attributes.attribute(EndpointsConfiguration.SECURITY_REALM).set((Object)securityRealm);
        return this;
    }

    public EndpointConfigurationBuilder addEndpoint(String socketBindingName) {
        if (this.endpoints.remove(socketBindingName) != null) {
            Server.log.endpointSocketBindingOverride(socketBindingName);
        }
        EndpointConfigurationBuilder builder = new EndpointConfigurationBuilder(this.server, socketBindingName);
        this.endpoints.put(socketBindingName, builder);
        this.current = builder;
        return builder;
    }

    public EndpointConfigurationBuilder current() {
        return this.current;
    }

    public Map<String, EndpointConfigurationBuilder> endpoints() {
        return this.endpoints;
    }

    public EndpointsConfiguration create() {
        throw new UnsupportedOperationException();
    }

    public EndpointsConfiguration create(GlobalConfigurationBuilder builder, SocketBindingsConfiguration bindingsConfiguration, SecurityConfiguration securityConfiguration) {
        List<EndpointConfiguration> list = this.endpoints.values().stream().map(e -> e.create(bindingsConfiguration, securityConfiguration)).collect(Collectors.toList());
        boolean withAuthn = false;
        if (builder.security().authorization().isEnabled()) {
            for (EndpointConfiguration endpoint : list) {
                for (ProtocolServerConfiguration connector : endpoint.connectors()) {
                    if (connector instanceof HotRodServerConfiguration && ((HotRodServerConfiguration)connector).authentication().enabled()) {
                        withAuthn = true;
                    }
                    if (!(connector instanceof RestServerConfiguration) || !((RestServerConfiguration)connector).authentication().enabled()) continue;
                    withAuthn = true;
                }
            }
            if (!withAuthn) {
                throw Server.log.authorizationWithoutAuthentication();
            }
        }
        return new EndpointsConfiguration(this.attributes.protect(), list);
    }

    public EndpointsConfigurationBuilder read(EndpointsConfiguration template) {
        this.attributes.read(template.attributes());
        this.endpoints.clear();
        return this;
    }

    public void validate() {
        for (EndpointConfigurationBuilder endpoint : this.endpoints.values()) {
            endpoint.validate();
        }
    }
}

