/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.security.Principal;
import java.security.Provider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.security.ElytronSubjectSaslServer;
import org.infinispan.server.security.ServerSecurityRealm;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.sasl.SaslAuthenticationFactory;
import org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider;
import org.wildfly.security.sasl.external.WildFlyElytronSaslExternalProvider;
import org.wildfly.security.sasl.gs2.WildFlyElytronSaslGs2Provider;
import org.wildfly.security.sasl.gssapi.WildFlyElytronSaslGssapiProvider;
import org.wildfly.security.sasl.localuser.WildFlyElytronSaslLocalUserProvider;
import org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider;
import org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider;
import org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider;
import org.wildfly.security.sasl.util.AggregateSaslServerFactory;
import org.wildfly.security.sasl.util.FilterMechanismSaslServerFactory;
import org.wildfly.security.sasl.util.PropertiesSaslServerFactory;
import org.wildfly.security.sasl.util.ProtocolSaslServerFactory;
import org.wildfly.security.sasl.util.SecurityProviderSaslServerFactory;
import org.wildfly.security.sasl.util.ServerNameSaslServerFactory;

public class ElytronSASLAuthenticationProvider
implements ServerAuthenticationProvider {
    private final String name;
    private final String serverPrincipal;
    private final Collection<String> mechanisms;
    private SaslAuthenticationFactory saslAuthenticationFactory;

    public ElytronSASLAuthenticationProvider(String name, String serverPrincipal, Collection<String> mechanisms) {
        this.name = name;
        this.serverPrincipal = serverPrincipal;
        this.mechanisms = mechanisms;
    }

    public static void init(HotRodServerConfiguration configuration, ServerConfiguration serverConfiguration, ScheduledExecutorService timeoutExecutor) {
        ElytronSASLAuthenticationProvider authenticator = (ElytronSASLAuthenticationProvider)configuration.authentication().serverAuthenticationProvider();
        if (authenticator != null) {
            authenticator.init(serverConfiguration, timeoutExecutor);
        }
    }

    public void init(ServerConfiguration serverConfiguration, ScheduledExecutorService timeoutExecutor) {
        Provider[] providers = new Provider[]{WildFlyElytronSaslPlainProvider.getInstance(), WildFlyElytronSaslDigestProvider.getInstance(), WildFlyElytronSaslScramProvider.getInstance(), WildFlyElytronSaslExternalProvider.getInstance(), WildFlyElytronSaslLocalUserProvider.getInstance(), WildFlyElytronSaslOAuth2Provider.getInstance(), WildFlyElytronSaslGssapiProvider.getInstance(), WildFlyElytronSaslGs2Provider.getInstance()};
        SecurityProviderSaslServerFactory securityProviderSaslServerFactory = new SecurityProviderSaslServerFactory(() -> providers);
        ServerSecurityRealm realm = serverConfiguration.security().realms().getRealm(this.name).serverSecurityRealm();
        SaslAuthenticationFactory.Builder builder = SaslAuthenticationFactory.builder();
        AggregateSaslServerFactory factory = new AggregateSaslServerFactory(new SaslServerFactory[]{new FilterMechanismSaslServerFactory((SaslServerFactory)securityProviderSaslServerFactory, true, this.mechanisms)});
        builder.setFactory((SaslServerFactory)factory);
        builder.setSecurityDomain(realm.getSecurityDomain());
        MechanismConfiguration.Builder mechConfigurationBuilder = MechanismConfiguration.builder();
        realm.applyServerCredentials(mechConfigurationBuilder, this.serverPrincipal);
        MechanismRealmConfiguration.Builder mechRealmBuilder = MechanismRealmConfiguration.builder();
        mechRealmBuilder.setRealmName(this.name);
        mechConfigurationBuilder.addMechanismRealm(mechRealmBuilder.build());
        builder.setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)mechConfigurationBuilder.build()));
        builder.setScheduledExecutorService(timeoutExecutor);
        this.saslAuthenticationFactory = builder.build();
    }

    public SaslServer createSaslServer(String mechanism, List<Principal> principals, String protocol, String serverName, Map<String, String> props) throws SaslException {
        SaslServer saslServer = (SaslServer)this.saslAuthenticationFactory.createMechanism(mechanism, factory -> {
            factory = new ServerNameSaslServerFactory(factory, serverName);
            factory = new ProtocolSaslServerFactory(factory, protocol);
            factory = props != null ? new PropertiesSaslServerFactory(factory, props) : factory;
            return factory;
        });
        return saslServer == null ? null : new ElytronSubjectSaslServer(saslServer, principals, null);
    }
}

