/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLEngineConfiguration;

public class SSLEngineConfigurationBuilder
implements Builder<SSLEngineConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder realmBuilder;

    SSLEngineConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = SSLEngineConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SSLEngineConfigurationBuilder enabledProtocols(String[] protocols) {
        this.attributes.attribute(SSLEngineConfiguration.ENABLED_PROTOCOLS).set((Object)protocols);
        return this;
    }

    public SSLEngineConfigurationBuilder enabledCiphersuitesFilter(String cipherSuitesFilter) {
        this.attributes.attribute(SSLEngineConfiguration.ENABLED_CIPHERSUITES).set((Object)cipherSuitesFilter);
        return this;
    }

    public SSLEngineConfigurationBuilder enabledCiphersuitesNames(String cipherSuitesNames) {
        this.attributes.attribute(SSLEngineConfiguration.ENABLED_CIPHERSUITES_13).set((Object)cipherSuitesNames);
        return this;
    }

    public SSLEngineConfiguration create() {
        return new SSLEngineConfiguration(this.attributes.protect());
    }

    public SSLEngineConfigurationBuilder read(SSLEngineConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

