/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.security.ServerSecurityRealm;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;

public class LdapUserPasswordMapperConfiguration
extends ConfigurationElement<LdapUserPasswordMapperConfiguration> {
    static final AttributeDefinition<String> FROM = AttributeDefinition.builder((Enum)Attribute.FROM, null, String.class).immutable().build();
    static final AttributeDefinition<Boolean> VERIFIABLE = AttributeDefinition.builder((Enum)Attribute.VERIFIABLE, (Object)true, Boolean.class).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LdapUserPasswordMapperConfiguration.class, new AttributeDefinition[]{FROM, VERIFIABLE});
    }

    LdapUserPasswordMapperConfiguration(AttributeSet attributes) {
        super((Enum)Element.USER_PASSWORD_MAPPER, attributes, new ConfigurationElement[0]);
    }

    void build(LdapSecurityRealmBuilder ldapRealmBuilder, RealmConfiguration realm) {
        if (this.attributes.attribute(FROM).get() != null) {
            LdapSecurityRealmBuilder.UserPasswordCredentialLoaderBuilder builder = ldapRealmBuilder.userPasswordCredentialLoader();
            builder.setUserPasswordAttribute((String)this.attributes.attribute(FROM).get());
            if (!((Boolean)this.attributes.attribute(VERIFIABLE).get()).booleanValue()) {
                builder.disableVerification();
            } else {
                realm.addFeature(ServerSecurityRealm.Feature.PASSWORD_HASHED);
            }
            builder.build();
        }
    }
}

