/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.security.CredentialStoresConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmsConfigurationBuilder;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.configuration.security.TransportSecurityConfigurationBuilder;

public class SecurityConfigurationBuilder
implements Builder<SecurityConfiguration> {
    private final CredentialStoresConfigurationBuilder credentialStoresConfiguration;
    private final RealmsConfigurationBuilder realmsConfiguration = new RealmsConfigurationBuilder();
    private final TransportSecurityConfigurationBuilder transport = new TransportSecurityConfigurationBuilder();
    private final ServerConfigurationBuilder builder;

    public SecurityConfigurationBuilder(ServerConfigurationBuilder builder) {
        this.builder = builder;
        this.credentialStoresConfiguration = new CredentialStoresConfigurationBuilder(builder);
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public CredentialStoresConfigurationBuilder credentialStores() {
        return this.credentialStoresConfiguration;
    }

    public RealmsConfigurationBuilder realms() {
        return this.realmsConfiguration;
    }

    public void validate() {
        this.credentialStoresConfiguration.validate();
        this.realmsConfiguration.validate();
        this.transport.validate();
    }

    public SecurityConfiguration create() {
        return new SecurityConfiguration(this.credentialStoresConfiguration.create(), this.realmsConfiguration.create(), this.transport.create(), this.builder.properties());
    }

    public SecurityConfigurationBuilder read(SecurityConfiguration template) {
        this.credentialStoresConfiguration.read(template.credentialStores());
        this.realmsConfiguration.read(template.realms());
        return this;
    }

    public TransportSecurityConfigurationBuilder transport() {
        return this.transport;
    }
}

