/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.endpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.authentication.RestAuthenticator;
import org.infinispan.rest.configuration.RestAuthenticationConfigurationBuilder;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingsConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.configuration.endpoint.SinglePortServerConfigurationBuilder;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfiguration;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.core.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.SaslAuthenticationConfigurationBuilder;
import org.infinispan.server.core.configuration.SaslConfigurationBuilder;
import org.infinispan.server.core.security.UsernamePasswordAuthenticator;
import org.infinispan.server.core.security.sasl.SaslAuthenticator;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfigurationBuilder;
import org.infinispan.server.memcached.configuration.MemcachedProtocol;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.server.resp.authentication.RespAuthenticator;
import org.infinispan.server.resp.configuration.RespAuthenticationConfigurationBuilder;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.server.security.ElytronHTTPAuthenticator;
import org.infinispan.server.security.ElytronRESPAuthenticator;
import org.infinispan.server.security.ElytronSASLAuthenticator;
import org.infinispan.server.security.ElytronUsernamePasswordAuthenticator;
import org.infinispan.server.security.RespClientCertAuthenticator;
import org.infinispan.server.security.ServerSecurityRealm;

public class EndpointConfigurationBuilder
implements Builder<EndpointConfiguration> {
    private final AttributeSet attributes;
    private final List<ProtocolServerConfigurationBuilder<?, ?, ?>> connectorBuilders = new ArrayList(2);
    private final SinglePortServerConfigurationBuilder singlePortBuilder = new SinglePortServerConfigurationBuilder();
    private boolean implicitConnectorSecurity;

    public EndpointConfigurationBuilder(ServerConfigurationBuilder serverConfigurationBuilder, String socketBindingName) {
        this.attributes = EndpointConfiguration.attributeDefinitionSet();
        this.attributes.attribute(EndpointConfiguration.SOCKET_BINDING).set((Object)socketBindingName);
        this.singlePortBuilder.socketBinding(socketBindingName);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public EndpointConfigurationBuilder securityRealm(String name) {
        this.attributes.attribute(EndpointConfiguration.SECURITY_REALM).set((Object)name);
        return this;
    }

    public String securityRealm() {
        return (String)this.attributes.attribute(EndpointConfiguration.SECURITY_REALM).get();
    }

    public EndpointConfigurationBuilder implicitConnectorSecurity(boolean implicitConnectorSecurity) {
        this.implicitConnectorSecurity = implicitConnectorSecurity;
        return this;
    }

    public EndpointConfigurationBuilder admin(boolean admin) {
        this.attributes.attribute(EndpointConfiguration.ADMIN).set((Object)admin);
        return this;
    }

    public boolean admin() {
        return (Boolean)this.attributes.attribute(EndpointConfiguration.ADMIN).get();
    }

    public EndpointConfigurationBuilder metricsAuth(boolean auth) {
        this.attributes.attribute(EndpointConfiguration.METRICS_AUTH).set((Object)auth);
        return this;
    }

    public boolean metricsAuth() {
        return (Boolean)this.attributes.attribute(EndpointConfiguration.METRICS_AUTH).get();
    }

    public List<ProtocolServerConfigurationBuilder<?, ?, ?>> connectors() {
        return this.connectorBuilders;
    }

    public SinglePortServerConfigurationBuilder singlePort() {
        return this.singlePortBuilder;
    }

    public <T extends ProtocolServerConfigurationBuilder<?, ?, ?>> T addConnector(Class<T> klass) {
        try {
            ProtocolServerConfigurationBuilder builder = (ProtocolServerConfigurationBuilder)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.connectorBuilders.add(builder);
            this.singlePortBuilder.applyConfigurationToProtocol(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw Server.log.cannotInstantiateProtocolServerConfigurationBuilder(klass, e);
        }
    }

    public void validate() {
        Map<String, List<ProtocolServerConfigurationBuilder>> buildersPerClass = this.connectorBuilders.stream().collect(Collectors.groupingBy(s -> s.getClass().getSimpleName() + "/" + s.socketBinding()));
        buildersPerClass.values().stream().filter(c -> c.size() > 1).findFirst().ifPresent(c -> {
            String names = c.stream().map(ProtocolServerConfigurationBuilder::name).collect(Collectors.joining(","));
            throw Server.log.multipleEndpointsSameTypeFound(names);
        });
    }

    public EndpointConfiguration create() {
        throw new UnsupportedOperationException();
    }

    public EndpointConfiguration create(SocketBindingsConfiguration bindingsConfiguration, SecurityConfiguration securityConfiguration) {
        RealmConfiguration realm;
        boolean implicitSecurity = this.implicitConnectorSecurity && this.securityRealm() != null;
        bindingsConfiguration.applySocketBinding((String)this.attributes.attribute(EndpointConfiguration.SOCKET_BINDING).get(), this.singlePortBuilder, this.singlePortBuilder);
        ArrayList connectors = new ArrayList(this.connectorBuilders.size());
        for (ProtocolServerConfigurationBuilder<?, ?, ?> builder : this.connectorBuilders) {
            bindingsConfiguration.applySocketBinding(builder.socketBinding(), builder, this.singlePortBuilder);
            if (implicitSecurity) {
                if (builder instanceof HotRodServerConfigurationBuilder) {
                    EndpointConfigurationBuilder.enableImplicitAuthentication(securityConfiguration, this.securityRealm(), (HotRodServerConfigurationBuilder)builder);
                } else if (builder instanceof RestServerConfigurationBuilder) {
                    EndpointConfigurationBuilder.enableImplicitAuthentication(securityConfiguration, this.securityRealm(), (RestServerConfigurationBuilder)builder);
                } else if (builder instanceof RespServerConfigurationBuilder) {
                    builder = this.enableImplicitAuthentication(securityConfiguration, this.securityRealm(), (RespServerConfigurationBuilder)builder);
                } else if (builder instanceof MemcachedServerConfigurationBuilder) {
                    builder = this.enableImplicitAuthentication(securityConfiguration, this.securityRealm(), (MemcachedServerConfigurationBuilder)builder);
                }
            }
            if (builder == null) continue;
            connectors.add((ProtocolServerConfiguration)builder.create());
        }
        if (implicitSecurity && (realm = securityConfiguration.realms().getRealm(this.securityRealm())).hasFeature(ServerSecurityRealm.Feature.ENCRYPT)) {
            this.singlePortBuilder.ssl().enable().sslContext(realm.serverSSLContext());
        }
        return new EndpointConfiguration(this.attributes.protect(), connectors, this.singlePortBuilder.create());
    }

    public EndpointConfigurationBuilder read(EndpointConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public static void enableImplicitAuthentication(SecurityConfiguration security, String securityRealmName, HotRodServerConfigurationBuilder builder) {
        SaslAuthenticationConfigurationBuilder authentication = builder.authentication();
        if (!authentication.hasSecurityRealm()) {
            authentication.securityRealm(securityRealmName);
            Server.log.debugf("Using endpoint realm \"%s\" for Hot Rod", securityRealmName);
        }
        ServerSecurityRealm securityRealm = security.realms().getRealm(authentication.securityRealm()).serverSecurityRealm();
        EndpointConfigurationBuilder.enableSaslAuthentication(authentication, authentication.sasl(), securityRealm, "hotrod/", "Hot Rod");
    }

    private static void enableSaslAuthentication(AuthenticationConfigurationBuilder<?> authentication, SaslConfigurationBuilder sasl, ServerSecurityRealm securityRealm, String identityPrefix, String name) {
        if (!sasl.hasMechanisms()) {
            String serverPrincipal = null;
            for (KerberosSecurityFactoryConfiguration identity : securityRealm.getServerIdentities().kerberosConfigurations()) {
                if (identity.getPrincipal().startsWith(identityPrefix)) {
                    authentication.enable();
                    sasl.addMechanisms(new String[]{"GS2-KRB5", "GSSAPI"});
                    serverPrincipal = identity.getPrincipal();
                    break;
                }
                Server.log.debugf("Enabled Kerberos mechanisms for %s using principal '%s'", name, identity.getPrincipal());
            }
            if (securityRealm.hasFeature(ServerSecurityRealm.Feature.TOKEN)) {
                authentication.enable();
                sasl.addMechanisms(new String[]{"OAUTHBEARER"});
                Server.log.debugf("Enabled OAUTHBEARER mechanism for %s", name);
            }
            if (securityRealm.hasFeature(ServerSecurityRealm.Feature.TRUST)) {
                authentication.enable();
                sasl.addMechanisms(new String[]{"EXTERNAL"});
                Server.log.debugf("Enabled EXTERNAL mechanism for %s", name);
            }
            if (securityRealm.hasFeature(ServerSecurityRealm.Feature.PASSWORD_HASHED)) {
                authentication.enable();
                sasl.addMechanisms(new String[]{"SCRAM-SHA-512", "SCRAM-SHA-384", "SCRAM-SHA-256", "SCRAM-SHA-1", "DIGEST-SHA-512", "DIGEST-SHA-384", "DIGEST-SHA-256", "DIGEST-SHA", "CRAM-MD5", "DIGEST-MD5"});
                Server.log.debugf("Enabled SCRAM, DIGEST and CRAM mechanisms for %s", name);
                if (securityRealm.hasFeature(ServerSecurityRealm.Feature.ENCRYPT)) {
                    authentication.enable();
                    sasl.addMechanisms(new String[]{"PLAIN"});
                    Server.log.debugf("Enabled PLAIN mechanism for %s", name);
                }
            }
            sasl.authenticator((SaslAuthenticator)new ElytronSASLAuthenticator(authentication.securityRealm(), serverPrincipal, sasl.mechanisms()));
        }
    }

    public static void enableImplicitAuthentication(SecurityConfiguration security, String securityRealmName, RestServerConfigurationBuilder builder) {
        RestAuthenticationConfigurationBuilder authentication = builder.authentication();
        if (!authentication.hasSecurityRealm()) {
            authentication.securityRealm(securityRealmName);
        }
        ServerSecurityRealm securityRealm = security.realms().getRealm(authentication.securityRealm()).serverSecurityRealm();
        if (!authentication.hasMechanisms()) {
            String serverPrincipal = null;
            for (KerberosSecurityFactoryConfiguration identity : securityRealm.getServerIdentities().kerberosConfigurations()) {
                if (identity.getPrincipal().startsWith("HTTP/")) {
                    authentication.enable().addMechanisms(new String[]{"SPNEGO"});
                    serverPrincipal = identity.getPrincipal();
                }
                Server.log.debugf("Enabled SPNEGO authentication for HTTP using principal '%s'", identity.getPrincipal());
            }
            if (securityRealm.hasFeature(ServerSecurityRealm.Feature.TOKEN)) {
                authentication.enable().addMechanisms(new String[]{"BEARER_TOKEN"});
                Server.log.debug("Enabled BEARER_TOKEN for HTTP");
            }
            if (securityRealm.hasFeature(ServerSecurityRealm.Feature.TRUST)) {
                authentication.enable().addMechanisms(new String[]{"CLIENT_CERT"});
                Server.log.debug("Enabled CLIENT_CERT for HTTP");
            }
            if (securityRealm.hasFeature(ServerSecurityRealm.Feature.PASSWORD_HASHED)) {
                authentication.enable().addMechanisms(new String[]{"DIGEST"});
                Server.log.debug("Enabled DIGEST for HTTP");
                if (securityRealm.hasFeature(ServerSecurityRealm.Feature.ENCRYPT)) {
                    authentication.enable().addMechanisms(new String[]{"BASIC"});
                    Server.log.debug("Enabled BASIC for HTTP");
                }
            }
            authentication.authenticator((RestAuthenticator)new ElytronHTTPAuthenticator(authentication.securityRealm(), serverPrincipal, authentication.mechanisms()));
        }
    }

    private ProtocolServerConfigurationBuilder<?, ?, ?> enableImplicitAuthentication(SecurityConfiguration security, String securityRealmName, RespServerConfigurationBuilder builder) {
        RespAuthenticationConfigurationBuilder authentication = builder.authentication();
        if (!authentication.hasSecurityRealm()) {
            authentication.securityRealm(securityRealmName);
        }
        boolean authSupported = false;
        ServerSecurityRealm securityRealm = security.realms().getRealm(authentication.securityRealm()).serverSecurityRealm();
        ElytronRESPAuthenticator respAuthenticator = new ElytronRESPAuthenticator();
        if (securityRealm.hasFeature(ServerSecurityRealm.Feature.PASSWORD_PLAIN)) {
            respAuthenticator.withUsernamePasswordAuth(new ElytronUsernamePasswordAuthenticator(authentication.securityRealm()));
            authSupported = true;
        }
        if (securityRealm.hasFeature(ServerSecurityRealm.Feature.TRUST)) {
            respAuthenticator.withClientCertAuth(new RespClientCertAuthenticator(authentication.securityRealm()));
            authSupported = true;
        }
        if (!authSupported) {
            if (builder.implicitConnector()) {
                return null;
            }
            if (!securityRealm.isAnonymous()) {
                throw Server.log.respEndpointRequiresRealmWithPasswordOrTrustore();
            }
            return builder;
        }
        authentication.authenticator((RespAuthenticator)respAuthenticator);
        return builder;
    }

    private ProtocolServerConfigurationBuilder<?, ?, ?> enableImplicitAuthentication(SecurityConfiguration security, String securityRealmName, MemcachedServerConfigurationBuilder builder) {
        MemcachedAuthenticationConfigurationBuilder authentication = builder.authentication();
        if (!authentication.hasSecurityRealm()) {
            authentication.securityRealm(securityRealmName);
        }
        ServerSecurityRealm securityRealm = security.realms().getRealm(authentication.securityRealm()).serverSecurityRealm();
        MemcachedProtocol protocol = builder.protocol();
        if (protocol.isBinary()) {
            EndpointConfigurationBuilder.enableSaslAuthentication(authentication, authentication.sasl(), securityRealm, "memcached/", "Memcached");
        }
        if (protocol.isText()) {
            if (securityRealm.hasFeature(ServerSecurityRealm.Feature.PASSWORD_PLAIN)) {
                authentication.text().authenticator((UsernamePasswordAuthenticator)new ElytronUsernamePasswordAuthenticator(authentication.securityRealm()));
            } else {
                if (builder.implicitConnector()) {
                    return null;
                }
                if (!securityRealm.isAnonymous()) {
                    throw Server.log.memcachedTextEndpointRequiresRealmWithPassword();
                }
                return builder;
            }
        }
        return builder;
    }
}

