/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.nio.charset.StandardCharsets;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.security.HostnameVerificationPolicy;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;

public class JwtConfiguration
extends ConfigurationElement<JwtConfiguration> {
    static final AttributeDefinition<String[]> AUDIENCE = AttributeDefinition.builder((Enum)Attribute.AUDIENCE, null, String[].class).build();
    static final AttributeDefinition<String> CLIENT_SSL_CONTEXT = AttributeDefinition.builder((Enum)Attribute.CLIENT_SSL_CONTEXT, null, String.class).build();
    static final AttributeDefinition<String> HOST_NAME_VERIFICATION_POLICY = AttributeDefinition.builder((Enum)Attribute.HOST_NAME_VERIFICATION_POLICY, null, String.class).build();
    static final AttributeDefinition<String[]> ISSUER = AttributeDefinition.builder((Enum)Attribute.ISSUER, null, String[].class).build();
    static final AttributeDefinition<TimeQuantity> JKU_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.JKU_TIMEOUT, (Object)TimeQuantity.valueOf((String)"2m")).parser(TimeQuantity.PARSER).build();
    static final AttributeDefinition<String> PUBLIC_KEY = AttributeDefinition.builder((Enum)Attribute.PUBLIC_KEY, null, String.class).build();
    static final AttributeDefinition<TimeQuantity> CONNECTION_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.CONNECTION_TIMEOUT, (Object)TimeQuantity.valueOf((String)"2s")).immutable().build();
    static final AttributeDefinition<TimeQuantity> READ_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.READ_TIMEOUT, (Object)TimeQuantity.valueOf((String)"2s")).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(JwtConfiguration.class, new AttributeDefinition[]{AUDIENCE, CLIENT_SSL_CONTEXT, HOST_NAME_VERIFICATION_POLICY, ISSUER, JKU_TIMEOUT, PUBLIC_KEY, CONNECTION_TIMEOUT, READ_TIMEOUT});
    }

    JwtConfiguration(AttributeSet attributes) {
        super((Enum)Element.JWT, attributes, new ConfigurationElement[0]);
    }

    public TokenValidator getValidator(SecurityConfiguration security, RealmConfiguration realm) {
        JwtValidator.Builder validatorBuilder = JwtValidator.builder();
        this.attributes.attribute(AUDIENCE).apply(arg_0 -> ((JwtValidator.Builder)validatorBuilder).audience(arg_0));
        this.attributes.attribute(ISSUER).apply(arg_0 -> ((JwtValidator.Builder)validatorBuilder).issuer(arg_0));
        this.attributes.attribute(JKU_TIMEOUT).apply(v -> validatorBuilder.setJkuTimeout(v.longValue()));
        this.attributes.attribute(PUBLIC_KEY).apply(v -> validatorBuilder.publicKey(v.getBytes(StandardCharsets.UTF_8)));
        this.attributes.attribute(HOST_NAME_VERIFICATION_POLICY).apply(v -> validatorBuilder.useSslHostnameVerifier(HostnameVerificationPolicy.valueOf(v).getVerifier()));
        this.attributes.attribute(CONNECTION_TIMEOUT).apply(v -> validatorBuilder.connectionTimeout(v.intValue()));
        this.attributes.attribute(READ_TIMEOUT).apply(v -> validatorBuilder.readTimeout(v.intValue()));
        RealmConfiguration sslRealm = this.attributes.attribute(CLIENT_SSL_CONTEXT).isNull() ? realm : security.realms().getRealm((String)this.attributes.attribute(CLIENT_SSL_CONTEXT).get());
        validatorBuilder.useSslContext(sslRealm.clientSSLContext());
        return validatorBuilder.build();
    }
}

