/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import io.netty.channel.ChannelHandlerContext;
import java.security.Principal;
import java.security.Provider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.RestAuthenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.security.GroupPrincipal;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.security.HttpServerRequestAdapter;
import org.infinispan.server.security.ServerSecurityRealm;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.http.HttpAuthenticationFactory;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.basic.WildFlyElytronHttpBasicProvider;
import org.wildfly.security.http.bearer.WildFlyElytronHttpBearerProvider;
import org.wildfly.security.http.cert.WildFlyElytronHttpClientCertProvider;
import org.wildfly.security.http.digest.DigestMechanismFactory;
import org.wildfly.security.http.digest.WildFlyElytronHttpDigestProvider;
import org.wildfly.security.http.spnego.WildFlyElytronHttpSpnegoProvider;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.SecurityProviderServerMechanismFactory;
import org.wildfly.security.http.util.SetMechanismInformationMechanismFactory;

public class ElytronHTTPAuthenticator
implements RestAuthenticator {
    private final String name;
    private final String serverPrincipal;
    private final Collection<String> mechanisms;
    private final Provider[] providers;
    private final Map<String, String> challengePrefixMechanisms;
    private HttpAuthenticationFactory factory;
    private ServerSecurityRealm serverSecurityRealm;
    private BlockingManager blockingManager;
    private RestServerConfiguration configuration;

    public ElytronHTTPAuthenticator(String name, String serverPrincipal, Collection<String> mechanisms) {
        this.name = name;
        this.serverPrincipal = serverPrincipal;
        this.mechanisms = mechanisms;
        this.providers = new Provider[]{WildFlyElytronHttpBasicProvider.getInstance(), WildFlyElytronHttpBearerProvider.getInstance(), WildFlyElytronHttpDigestProvider.getInstance(), WildFlyElytronHttpClientCertProvider.getInstance(), WildFlyElytronHttpSpnegoProvider.getInstance()};
        HashMap<String, String> prefixes = new HashMap<String, String>();
        Iterator<String> iterator = mechanisms.iterator();
        block16: while (iterator.hasNext()) {
            String m;
            switch (m = iterator.next()) {
                case "BASIC": {
                    prefixes.put("BASIC", "BASIC");
                    continue block16;
                }
                case "SPNEGO": {
                    prefixes.put("NEGOTIATE", "SPNEGO");
                    continue block16;
                }
                case "BEARER_TOKEN": {
                    prefixes.put("BEARER", "BEARER_TOKEN");
                    continue block16;
                }
                case "DIGEST": {
                    prefixes.put("DIGEST", "DIGEST");
                    continue block16;
                }
                case "DIGEST-SHA-256": {
                    prefixes.put("DIGEST", "DIGEST-SHA-256");
                    continue block16;
                }
                case "DIGEST-SHA-512-256": {
                    prefixes.put("DIGEST", "DIGEST-SHA-512-256");
                    continue block16;
                }
            }
            prefixes.put(m, m);
        }
        this.challengePrefixMechanisms = Map.copyOf(prefixes);
    }

    public static void init(RestServerConfiguration configuration, ServerConfiguration serverConfiguration) {
        ElytronHTTPAuthenticator authenticator = (ElytronHTTPAuthenticator)configuration.authentication().authenticator();
        if (authenticator != null) {
            authenticator.init(serverConfiguration);
        }
    }

    public void init(ServerConfiguration serverConfiguration) {
        this.serverSecurityRealm = serverConfiguration.security().realms().getRealm(this.name).serverSecurityRealm();
        HttpAuthenticationFactory.Builder httpBuilder = HttpAuthenticationFactory.builder();
        httpBuilder.setSecurityDomain(this.serverSecurityRealm.getSecurityDomain());
        SecurityProviderServerMechanismFactory httpServerFactory = new SecurityProviderServerMechanismFactory(this.providers);
        httpServerFactory = new SetMechanismInformationMechanismFactory((HttpServerAuthenticationMechanismFactory)new FilterServerMechanismFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory, true, this.mechanisms));
        httpBuilder.setFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory);
        MechanismConfiguration.Builder mechConfigurationBuilder = MechanismConfiguration.builder();
        this.serverSecurityRealm.applyServerCredentials(mechConfigurationBuilder, this.serverPrincipal);
        MechanismRealmConfiguration.Builder mechRealmBuilder = MechanismRealmConfiguration.builder();
        mechRealmBuilder.setRealmName(this.name);
        mechConfigurationBuilder.addMechanismRealm(mechRealmBuilder.build());
        httpBuilder.setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)mechConfigurationBuilder.build()));
        this.factory = httpBuilder.build();
    }

    public CompletionStage<RestResponse> challenge(RestRequest request, ChannelHandlerContext ctx) {
        HttpServerRequestAdapter requestAdapter = new HttpServerRequestAdapter(request, ctx);
        return this.blockingManager.supplyBlocking(() -> {
            try {
                String authorizationHeader = request.getAuthorizationHeader();
                if (authorizationHeader == null) {
                    for (String name : this.configuration.authentication().mechanisms()) {
                        HttpServerAuthenticationMechanism mechanism = (HttpServerAuthenticationMechanism)this.factory.createMechanism(name);
                        mechanism.evaluateRequest((HttpServerRequest)requestAdapter);
                        this.extractSubject(request, mechanism);
                    }
                } else {
                    String headerMechName = authorizationHeader.substring(0, authorizationHeader.indexOf(32)).toUpperCase();
                    String mechName = this.challengePrefixMechanisms.get(headerMechName);
                    HttpServerAuthenticationMechanism mechanism = (HttpServerAuthenticationMechanism)this.factory.createMechanism(mechName);
                    if (mechanism == null) {
                        throw Server.log.unsupportedMechanism(headerMechName);
                    }
                    mechanism.evaluateRequest((HttpServerRequest)requestAdapter);
                    this.extractSubject(request, mechanism);
                }
                return requestAdapter.getResponse();
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }, (Object)"auth");
    }

    private void extractSubject(RestRequest request, HttpServerAuthenticationMechanism mechanism) {
        SecurityIdentity securityIdentity = (SecurityIdentity)mechanism.getNegotiatedProperty("wildfly.http.security-identity");
        if (securityIdentity != null) {
            Subject subject = new Subject();
            subject.getPrincipals().add(securityIdentity.getPrincipal());
            securityIdentity.getRoles().forEach(r -> subject.getPrincipals().add((Principal)new GroupPrincipal(r)));
            request.setSubject(subject);
        }
    }

    public void init(RestServer restServer) {
        this.configuration = (RestServerConfiguration)restServer.getConfiguration();
        this.blockingManager = restServer.getBlockingManager();
        for (String name : this.configuration.authentication().mechanisms()) {
            try {
                this.factory.createMechanism(name);
            }
            catch (HttpAuthenticationException e) {
                throw new CacheConfigurationException("Could not create HTTP authentication mechanism " + name);
            }
        }
    }

    public boolean isReadyForHttpChallenge() {
        return this.serverSecurityRealm.isReadyForHttpChallenge();
    }

    public void close() {
        if (Boolean.parseBoolean(System.getProperty("infinispan.security.elytron.nonceshutdown", "true"))) {
            new DigestMechanismFactory().shutdown();
        }
        this.factory.shutdownAuthenticationMechanismFactory();
    }
}

