/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.util.Properties;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class InfinispanServerRuleBuilder {
    private final String configurationFile;
    private final Properties properties;
    private String[] mavenArtifacts;
    private int numServers = 2;
    private ServerRunMode runMode = ServerRunMode.DEFAULT;
    private JavaArchive[] archives;
    private boolean jmx;
    private boolean parallelStartup = true;

    public static InfinispanServerRuleBuilder config(String configurationFile) {
        return new InfinispanServerRuleBuilder(configurationFile);
    }

    private InfinispanServerRuleBuilder(String configurationFile) {
        this.configurationFile = configurationFile;
        this.properties = new Properties(System.getProperties());
        System.getProperties().entrySet().stream().filter(e -> e.getKey().toString().startsWith("org.infinispan")).forEach(e -> this.properties.put(e.getKey(), e.getValue()));
    }

    public InfinispanServerRuleBuilder mavenArtifacts(String ... mavenArtifacts) {
        this.mavenArtifacts = mavenArtifacts;
        return this;
    }

    public InfinispanServerRuleBuilder numServers(int numServers) {
        this.numServers = numServers;
        return this;
    }

    public InfinispanServerRuleBuilder runMode(ServerRunMode serverRunMode) {
        this.runMode = serverRunMode;
        return this;
    }

    public InfinispanServerRuleBuilder artifacts(JavaArchive ... archives) {
        this.archives = archives;
        return this;
    }

    public InfinispanServerRuleBuilder property(String name, String value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public InfinispanServerRuleBuilder enableJMX() {
        this.jmx = true;
        return this;
    }

    public InfinispanServerRuleBuilder parallelStartup(boolean parallel) {
        this.parallelStartup = parallel;
        return this;
    }

    public InfinispanServerRule build() {
        InfinispanServerTestConfiguration configuration = new InfinispanServerTestConfiguration(this.configurationFile, this.numServers, this.runMode, this.properties, this.mavenArtifacts, this.archives, this.jmx, this.parallelStartup);
        return new InfinispanServerRule(configuration);
    }
}

