/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.io.Closeable;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.model.Statement;

public class InfinispanServerRule
implements TestRule {
    private InfinispanServerDriver serverDriver;
    private InfinispanServerTestConfiguration configuration;
    protected final List<Consumer<File>> configurationEnhancers = new ArrayList<Consumer<File>>();

    public InfinispanServerRule(InfinispanServerTestConfiguration configuration) {
        this.configuration = configuration;
    }

    public void registerConfigurationEnhancer(Consumer<File> enhancer) {
        this.configurationEnhancers.add(enhancer);
    }

    public InfinispanServerDriver getServerDriver() {
        if (this.serverDriver == null) {
            throw new IllegalStateException("Operation not supported before test starts");
        }
        return this.serverDriver;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                boolean inSuite;
                String testName = description.getTestClass().getName();
                RunWith runWith = description.getTestClass().getAnnotation(RunWith.class);
                boolean bl = inSuite = runWith != null && runWith.value() == Suite.class;
                if (!inSuite) {
                    TestResourceTracker.testStarted((String)testName);
                }
                boolean manageServer = InfinispanServerRule.this.serverDriver == null;
                try {
                    if (manageServer) {
                        InfinispanServerRule.this.serverDriver = (InfinispanServerDriver)InfinispanServerRule.this.configuration.runMode().newDriver(InfinispanServerRule.this.configuration);
                        InfinispanServerRule.this.serverDriver.prepare(testName);
                        InfinispanServerRule.this.configurationEnhancers.forEach(c -> c.accept(InfinispanServerRule.this.serverDriver.getConfDir()));
                        InfinispanServerRule.this.serverDriver.start(testName);
                    }
                    InfinispanServerRule.this.before(testName);
                    base.evaluate();
                }
                finally {
                    InfinispanServerRule.this.after(testName);
                    if (manageServer && InfinispanServerRule.this.serverDriver != null) {
                        InfinispanServerRule.this.serverDriver.stop(testName);
                    }
                    if (!inSuite) {
                        TestResourceTracker.testFinished((String)testName);
                    }
                }
            }
        };
    }

    private void before(String name) {
    }

    private void after(String name) {
    }

    RemoteCacheManager newHotRodClient() {
        return this.newHotRodClient(new ConfigurationBuilder());
    }

    RemoteCacheManager newHotRodClient(ConfigurationBuilder builder) {
        for (int i = 0; i < this.getServerDriver().getConfiguration().numServers(); ++i) {
            InetSocketAddress serverAddress = this.getServerDriver().getServerSocket(i, 11222);
            builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        }
        return this.getServerDriver().createRemoteCacheManager(builder);
    }

    public RestClient newRestClient() {
        return this.newRestClient(new RestClientConfigurationBuilder());
    }

    public RestClient newRestClient(RestClientConfigurationBuilder builder) {
        for (int i = 0; i < this.getServerDriver().getConfiguration().numServers(); ++i) {
            InetSocketAddress serverAddress = this.getServerDriver().getServerSocket(i, 11222);
            builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        }
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    public RestClient newRestClient(RestClientConfigurationBuilder builder, int n) {
        InetSocketAddress serverAddress = this.getServerDriver().getServerSocket(n, 11222);
        builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    CloseableMemcachedClient newMemcachedClient() {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < this.getServerDriver().getConfiguration().numServers(); ++i) {
            InetSocketAddress unresolved = this.getServerDriver().getServerSocket(i, 11221);
            addresses.add(new InetSocketAddress(unresolved.getHostName(), unresolved.getPort()));
        }
        MemcachedClient memcachedClient = (MemcachedClient)Exceptions.unchecked(() -> new MemcachedClient(addresses));
        return new CloseableMemcachedClient(memcachedClient);
    }

    public static class CloseableMemcachedClient
    implements Closeable {
        final MemcachedClient client;

        public CloseableMemcachedClient(MemcachedClient client) {
            this.client = client;
        }

        public MemcachedClient getClient() {
            return this.client;
        }

        @Override
        public void close() {
            this.client.shutdown();
        }
    }
}

