/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class InfinispanServerExtension
implements TestClientDriver,
BeforeAllCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
AfterAllCallback {
    private final TestServer testServer;
    private final List<Consumer<File>> configurationEnhancers = new ArrayList<Consumer<File>>();
    private TestClient testClient;
    private String methodName;

    public InfinispanServerExtension(InfinispanServerTestConfiguration configuration) {
        this.testServer = new TestServer(configuration);
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        boolean manageServer;
        String testName = extensionContext.getRequiredTestClass().getName();
        boolean bl = manageServer = !this.testServer.isDriverInitialized();
        if (manageServer) {
            this.testServer.initServerDriver();
            this.testServer.beforeListeners();
            this.testServer.getDriver().prepare(testName);
            this.configurationEnhancers.forEach(c -> c.accept(this.testServer.getDriver().getConfDir()));
            this.testServer.getDriver().start(testName);
        }
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        this.testClient = new TestClient(this.testServer);
        this.testClient.initResources();
        this.methodName = extensionContext.getRequiredTestClass().getSimpleName() + "." + extensionContext.getRequiredTestMethod().getName();
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        this.testClient.clearResources();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        String testName = extensionContext.getRequiredTestClass().getName();
        if (this.testServer.isDriverInitialized()) {
            this.testServer.afterListeners();
            this.testServer.getDriver().stop(testName);
        }
    }

    public HotRodTestClientDriver hotrod() {
        return this.testClient.hotrod();
    }

    public RestTestClientDriver rest() {
        return this.testClient.rest();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public CounterManager getCounterManager() {
        return this.testClient.getCounterManager();
    }
}

