/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientXSiteDriver;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class InfinispanXSiteServerExtension
implements TestClientXSiteDriver,
BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private final List<TestServer> testServers;
    private final Map<String, TestClient> testClients = new HashMap<String, TestClient>();

    public InfinispanXSiteServerExtension(List<TestServer> testServers) {
        this.testServers = testServers;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        String testName = extensionContext.getRequiredTestClass().getName();
        this.testServers.forEach(it -> {
            boolean manageServer;
            boolean bl = manageServer = !it.isDriverInitialized();
            if (manageServer) {
                it.initServerDriver();
                it.beforeListeners();
                it.getDriver().prepare(testName);
                it.getDriver().start(testName);
            }
        });
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.testServers.forEach(it -> {
            TestClient testClient = new TestClient(it);
            testClient.initResources();
            this.testClients.put(it.getSiteName(), testClient);
        });
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.testClients.values().forEach(TestClient::clearResources);
    }

    public void afterAll(ExtensionContext extensionContext) {
        String testName = extensionContext.getRequiredTestClass().getName();
        this.testServers.forEach(it -> {
            if (it.isDriverInitialized()) {
                it.afterListeners();
                it.getDriver().stop(testName);
            }
        });
    }

    public HotRodTestClientDriver hotrod(String siteName) {
        return this.testClients.get(siteName).hotrod();
    }

    public RestTestClientDriver rest(String siteName) {
        return this.testClients.get(siteName).rest();
    }

    public String getMethodName() {
        return this.testClients.values().iterator().next().getMethodName();
    }

    public CounterManager getCounterManager(String siteName) {
        return this.testClients.get(siteName).getCounterManager();
    }
}

