/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.manager.CacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.transport.Decoder;
import org.infinispan.server.core.transport.Encoder;
import org.infinispan.server.websocket.OpHandler;
import org.infinispan.server.websocket.WebSocketServerHandler;
import org.infinispan.server.websocket.handlers.GetHandler;
import org.infinispan.server.websocket.handlers.NotifyHandler;
import org.infinispan.server.websocket.handlers.PutHandler;
import org.infinispan.server.websocket.handlers.RemoveHandler;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;

public class WebSocketServer
extends AbstractProtocolServer {
    public static final String INFINISPAN_WS_JS_FILENAME = "infinispan-ws.js";
    private static String javascript;
    private Channel channel;

    public WebSocketServer() {
        super("WebSocketServerThread");
    }

    public Encoder getEncoder() {
        return null;
    }

    public Decoder getDecoder() {
        return null;
    }

    public void start(String host, int port, EmbeddedCacheManager cacheManager, int masterThreads, int workerThreads, int idleTimeout) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        ExecutorService masterExecutor = masterThreads == 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(masterThreads);
        ExecutorService workerExecutor = workerThreads == 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(masterThreads);
        NioServerSocketChannelFactory factory = workerThreads == 0 ? new NioServerSocketChannelFactory((Executor)masterExecutor, (Executor)workerExecutor) : new NioServerSocketChannelFactory((Executor)masterExecutor, (Executor)workerExecutor, workerThreads);
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new WebSocketServerPipelineFactory((CacheManager)cacheManager));
        bootstrap.bind((SocketAddress)address);
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public static String getJavascript() {
        if (javascript != null) {
            return javascript;
        }
        BufferedReader scriptReader = new BufferedReader(new InputStreamReader(WebSocketServer.class.getResourceAsStream(INFINISPAN_WS_JS_FILENAME)));
        try {
            StringWriter writer = new StringWriter();
            String line = scriptReader.readLine();
            while (line != null) {
                writer.write(line);
                writer.write(10);
                line = scriptReader.readLine();
            }
            String string = javascript = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected exception while sending Websockets script to client.", e);
        }
        finally {
            try {
                scriptReader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected exception while closing Websockets script to client.", e);
            }
        }
    }

    private static class WebSocketServerPipelineFactory
    implements ChannelPipelineFactory {
        private CacheManager cacheManager;
        private Map<String, OpHandler> operationHandlers;
        private Map<String, Cache> startedCaches = new ConcurrentHashMap<String, Cache>();

        public WebSocketServerPipelineFactory(CacheManager cacheManager) {
            this.cacheManager = cacheManager;
            this.operationHandlers = new HashMap<String, OpHandler>();
            this.operationHandlers.put("put", new PutHandler());
            this.operationHandlers.put("get", new GetHandler());
            this.operationHandlers.put("remove", new RemoveHandler());
            NotifyHandler notifyHandler = new NotifyHandler();
            this.operationHandlers.put("notify", notifyHandler);
            this.operationHandlers.put("unnotify", notifyHandler);
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(65536));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("handler", (ChannelHandler)new WebSocketServerHandler(this.cacheManager, this.operationHandlers, this.startedCaches));
            return pipeline;
        }
    }
}

