/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket.handlers;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.server.websocket.CacheListener;
import org.infinispan.server.websocket.ChannelUtils;
import org.infinispan.server.websocket.OpHandler;
import org.infinispan.util.CollectionFactory;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.json.JSONException;
import org.json.JSONObject;

public class NotifyHandler
implements OpHandler {
    private Map<Cache, CacheListener> listeners = CollectionFactory.makeConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleOp(JSONObject opPayload, Cache<Object, Object> cache, ChannelHandlerContext ctx) throws JSONException {
        String[] keyTokens;
        String opCode = (String)opPayload.get("opCode");
        String key = (String)opPayload.opt("key");
        String[] onEvents = (String[])opPayload.opt("onEvents");
        CacheListener listener = this.listeners.get(cache);
        if (key == null) {
            key = "*";
        }
        if (listener == null) {
            NotifyHandler notifyHandler = this;
            synchronized (notifyHandler) {
                listener = this.listeners.get(cache);
                if (listener == null) {
                    listener = new CacheListener();
                    this.listeners.put(cache, listener);
                    cache.addListener((Object)listener);
                }
            }
        }
        for (String keyToken : keyTokens = key.split(",")) {
            CacheListener.ChannelNotifyParams notifyParams = new CacheListener.ChannelNotifyParams(ctx.getChannel(), keyToken, onEvents);
            if (opCode.equals("notify")) {
                listener.addChannel(notifyParams);
                if (keyToken.equals("*")) continue;
                ChannelUtils.pushCacheValue(keyToken, cache, ctx);
                continue;
            }
            if (!opCode.equals("unnotify")) continue;
            listener.removeChannel(notifyParams);
        }
    }
}

