/*
 * Decompiled with CFR 0.152.
 */
package infinispan.autoconfigure.remote;

import infinispan.autoconfigure.common.InfinispanProperties;
import infinispan.autoconfigure.remote.InfinispanRemoteCacheManagerChecker;
import infinispan.autoconfigure.remote.InfinispanRemoteConfigurer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

@org.springframework.context.annotation.Configuration
@ComponentScan
@ConditionalOnClass(name={"org.infinispan.client.hotrod.RemoteCacheManager"})
@ConditionalOnProperty(value={"infinispan.remote.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={InfinispanProperties.class})
public class InfinispanRemoteAutoConfiguration {
    public static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private InfinispanProperties infinispanProperties;
    @Autowired(required=false)
    private InfinispanRemoteConfigurer infinispanRemoteConfigurer;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @Conditional(value={InfinispanRemoteCacheManagerChecker.class})
    public RemoteCacheManager remoteCacheManager() throws IOException {
        Configuration configuration;
        InfinispanProperties.Remote remoteProperties = this.infinispanProperties.getRemote();
        boolean hasHotRodPropertiesFile = this.ctx.getResource(remoteProperties.getClientProperties()).exists();
        boolean hasConfigurer = this.infinispanRemoteConfigurer != null;
        boolean hasProperties = StringUtils.hasText((String)remoteProperties.getServerList());
        if (hasConfigurer) {
            configuration = this.infinispanRemoteConfigurer.getRemoteConfiguration();
        } else if (hasHotRodPropertiesFile) {
            String remoteClientPropertiesLocation = remoteProperties.getClientProperties();
            Resource hotRodClientPropertiesFile = this.ctx.getResource(remoteClientPropertiesLocation);
            Properties hotrodClientProperties = new Properties();
            try (InputStream stream = hotRodClientPropertiesFile.getURL().openStream();){
                hotrodClientProperties.load(stream);
                configuration = new ConfigurationBuilder().withProperties(hotrodClientProperties).build();
            }
        } else if (hasProperties) {
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
            configurationBuilder.addServers(remoteProperties.getServerList());
            Optional.ofNullable(remoteProperties.getConnectTimeout()).map(v -> configurationBuilder.connectionTimeout(v.intValue()));
            Optional.ofNullable(remoteProperties.getMaxRetries()).map(v -> configurationBuilder.maxRetries(v.intValue()));
            Optional.ofNullable(remoteProperties.getSocketTimeout()).map(v -> configurationBuilder.socketTimeout(v.intValue()));
            configuration = configurationBuilder.build();
        } else {
            throw new IllegalStateException("Not enough data to create RemoteCacheManager. Check InfinispanRemoteCacheManagerCheckerand update conditions.");
        }
        return new RemoteCacheManager(configuration);
    }
}

