/*
 * Decompiled with CFR 0.152.
 */
package infinispan.autoconfigure.remote;

import infinispan.autoconfigure.remote.InfinispanRemoteConfigurer;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class InfinispanRemoteCacheManagerChecker
implements Condition {
    public boolean matches(ConditionContext ctx, AnnotatedTypeMetadata atm) {
        return this.hasConfigurer(ctx) || this.hasHotRodClientPropertiesFile(ctx) || this.hasServersProperty(ctx);
    }

    public boolean hasServersProperty(ConditionContext conditionContext) {
        return conditionContext.getEnvironment().getProperty("infinispan.remote.server-list") != null;
    }

    public boolean hasConfigurer(ConditionContext conditionContext) {
        try {
            conditionContext.getBeanFactory().getBean(InfinispanRemoteConfigurer.class);
            return true;
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
    }

    public boolean hasHotRodClientPropertiesFile(ConditionContext conditionContext) {
        String hotRodPropertiesPath = conditionContext.getEnvironment().getProperty("infinispan.remote.client-properties");
        if (hotRodPropertiesPath == null) {
            hotRodPropertiesPath = "classpath:hotrod-client.properties";
        }
        return conditionContext.getResourceLoader().getResource(hotRodPropertiesPath).exists();
    }
}

