/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.embedded;

import org.assertj.core.api.Assertions;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedAutoConfiguration;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedCacheManagerAutoConfiguration;
import org.infinispan.spring.starter.embedded.InfinispanGlobalConfigurationCustomizer;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import test.org.infinispan.spring.starter.embedded.testconfiguration.InfinispanCacheTestConfiguration;

@SpringBootTest(classes={InfinispanEmbeddedAutoConfiguration.class, InfinispanEmbeddedCacheManagerAutoConfiguration.class, InfinispanCacheTestConfiguration.class, TestConfiguration.class}, properties={"spring.main.banner-mode=off"})
public class InfinispanEmbeddedAutoConfigurationIntegrationConfigurerTest {
    private static final String JMX_TEST_DOMAIN = InfinispanEmbeddedAutoConfigurationIntegrationConfigurerTest.class.getName();
    @Autowired
    EmbeddedCacheManager defaultCacheManager;

    @Test
    public void testWithCacheConfigurer() {
        Assertions.assertThat((Iterable)this.defaultCacheManager.getCacheNames()).containsExactlyInAnyOrder((Object[])new String[]{"test-simple-cache", "default"});
        org.infinispan.configuration.cache.Configuration testCacheConfiguration = this.defaultCacheManager.getCacheConfiguration("test-simple-cache");
        Assertions.assertThat((boolean)testCacheConfiguration.statistics().enabled()).isTrue();
        Assertions.assertThat((Comparable)testCacheConfiguration.memory().storageType()).isEqualTo((Object)StorageType.OBJECT);
        Assertions.assertThat((Comparable)testCacheConfiguration.memory().evictionType()).isEqualTo((Object)EvictionType.COUNT);
        Assertions.assertThat((Comparable)testCacheConfiguration.memory().evictionStrategy()).isEqualTo((Object)EvictionStrategy.MANUAL);
    }

    @Test
    public void testWithGlobalConfigurer() {
        GlobalConfiguration globalConfiguration = this.defaultCacheManager.getCacheManagerConfiguration();
        Assertions.assertThat((boolean)globalConfiguration.jmx().enabled()).isTrue();
        Assertions.assertThat((String)globalConfiguration.jmx().domain()).isEqualTo((Object)JMX_TEST_DOMAIN);
        Assertions.assertThat((String)globalConfiguration.transport().clusterName()).isEqualTo((Object)"TEST_CLUSTER");
    }

    @Configuration
    static class TestConfiguration {
        TestConfiguration() {
        }

        @Bean
        public InfinispanGlobalConfigurationCustomizer globalCustomizer() {
            return builder -> builder.jmx().domain(JMX_TEST_DOMAIN);
        }
    }
}

