/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.embedded;

import org.assertj.core.api.Assertions;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedAutoConfiguration;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedCacheManagerAutoConfiguration;
import org.infinispan.spring.starter.embedded.InfinispanGlobalConfigurer;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import test.org.infinispan.spring.starter.embedded.testconfiguration.GlobalConfigurerJmxDisabledConfiguration;
import test.org.infinispan.spring.starter.embedded.testconfiguration.InfinispanCacheConfigurationBaseTestConfiguration;
import test.org.infinispan.spring.starter.embedded.testconfiguration.InfinispanCacheConfigurationTestConfiguration;

@SpringBootTest(classes={InfinispanEmbeddedAutoConfiguration.class, InfinispanEmbeddedCacheManagerAutoConfiguration.class, InfinispanCacheConfigurationBaseTestConfiguration.class, InfinispanCacheConfigurationTestConfiguration.class, InfinispanGlobalConfigurer.class, GlobalConfigurerJmxDisabledConfiguration.class}, properties={"spring.main.banner-mode=off"})
public class InfinispanEmbeddedAutoConfigurationIntegrationConfigurationTest {
    @Autowired
    EmbeddedCacheManager manager;

    @Test
    public void testConfiguration() {
        Assertions.assertThat((Iterable)this.manager.getCacheNames()).contains((Object[])new String[]{"base-cache", "small-cache", "large-cache"});
        Assertions.assertThat((long)this.manager.getCacheConfiguration("base-cache").memory().size()).isEqualTo(500L);
        Assertions.assertThat((Comparable)this.manager.getCacheConfiguration("base-cache").memory().evictionType()).isEqualTo((Object)EvictionType.COUNT);
        Assertions.assertThat((long)this.manager.getCacheConfiguration("small-cache").memory().size()).isEqualTo(1000L);
        Assertions.assertThat((Comparable)this.manager.getCacheConfiguration("small-cache").memory().evictionType()).isEqualTo((Object)EvictionType.COUNT);
        Assertions.assertThat((long)this.manager.getCacheConfiguration("large-cache").memory().size()).isEqualTo(2000L);
        Assertions.assertThat((Comparable)this.manager.getCacheConfiguration("large-cache").memory().evictionType()).isEqualTo((Object)EvictionType.COUNT);
    }
}

