/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.embedded.actuator;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;

public class InfinispanCacheMeterBinder
extends CacheMeterBinder {
    private final Cache cache;

    public InfinispanCacheMeterBinder(Cache cache, Iterable<Tag> tags) {
        super((Object)cache, cache.getName(), tags);
        this.cache = cache;
    }

    protected Long size() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.getAdvancedCache().getStats().getCurrentNumberOfEntries();
    }

    protected long hitCount() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.getAdvancedCache().getStats().getHits();
    }

    protected Long missCount() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.getAdvancedCache().getStats().getMisses();
    }

    protected Long evictionCount() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.getAdvancedCache().getStats().getEvictions();
    }

    protected long putCount() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.getAdvancedCache().getStats().getStores();
    }

    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        if (this.cache == null) {
            return;
        }
        Gauge.builder((String)"cache.start", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getTimeSinceStart()).baseUnit(TimeUnit.SECONDS.name()).tags(this.getTagsWithCacheName()).description("Time elapsed since start").register(registry);
        Gauge.builder((String)"cache.reset", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getTimeSinceReset()).baseUnit(TimeUnit.SECONDS.name()).tags(this.getTagsWithCacheName()).description("Time elapsed since the last statistics reset").register(registry);
        this.memory(registry);
        this.averages(registry);
        this.averagesNanos(registry);
    }

    private void memory(MeterRegistry registry) {
        Gauge.builder((String)"cache.memory.size", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getCurrentNumberOfEntriesInMemory()).tags(this.getTagsWithCacheName()).description("Number of entries currently in the cache, excluding passivated entries").register(registry);
        if (this.cache.getCacheConfiguration().memory().evictionStrategy().isEnabled()) {
            Gauge.builder((String)"cache.memory.used", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getDataMemoryUsed()).tags(this.getTagsWithCacheName()).description("Provides how much memory the current eviction algorithm estimates is in use for data").register(registry);
        }
        Gauge.builder((String)"cache.memory.offHeap", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getOffHeapMemoryUsed()).tags(this.getTagsWithCacheName()).description("The amount of off-heap memory used by this cache").register(registry);
    }

    private void averages(MeterRegistry registry) {
        Gauge.builder((String)"cache.puts.latency", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getAverageWriteTime()).baseUnit(TimeUnit.MILLISECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache puts").register(registry);
        Gauge.builder((String)"cache.gets.latency", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getAverageReadTime()).baseUnit(TimeUnit.MILLISECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache gets").register(registry);
        Gauge.builder((String)"cache.removes.latency", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getAverageRemoveTime()).baseUnit(TimeUnit.MILLISECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache removes").register(registry);
    }

    private void averagesNanos(MeterRegistry registry) {
        Gauge.builder((String)"cache.puts.nlatency", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getAverageWriteTimeNanos()).baseUnit(TimeUnit.NANOSECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache puts in nanos").register(registry);
        Gauge.builder((String)"cache.gets.nlatency", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getAverageReadTimeNanos()).baseUnit(TimeUnit.NANOSECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache gets in nanos").register(registry);
        Gauge.builder((String)"cache.removes.nlatency", (Object)this.cache, cache -> cache.getAdvancedCache().getStats().getAverageRemoveTimeNanos()).baseUnit(TimeUnit.NANOSECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache removes in nanos").register(registry);
    }
}

