/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.embedded;

import org.assertj.core.api.Assertions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.spring.starter.embedded.InfinispanCacheConfigurer;
import org.infinispan.spring.starter.embedded.InfinispanConfigurationCustomizer;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedAutoConfiguration;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedCacheManagerAutoConfiguration;
import org.infinispan.spring.starter.embedded.InfinispanGlobalConfigurationCustomizer;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@SpringBootTest(classes={InfinispanEmbeddedAutoConfiguration.class, InfinispanEmbeddedCacheManagerAutoConfiguration.class, TestConfiguration.class}, properties={"spring.main.banner-mode=off"})
public class InfinispanEmbeddedAutoConfigurationCustomizerIntegrationTest {
    private static final String CLUSTER_NAME = Util.threadLocalRandomUUID().toString();
    @Autowired
    EmbeddedCacheManager manager;
    static CacheStartedEvent startedEvent;

    @Test
    public void testConfiguration() {
        Assertions.assertThat((String)this.manager.getCacheManagerConfiguration().transport().clusterName()).isEqualTo((Object)CLUSTER_NAME);
        Assertions.assertThat((Object)this.manager.getDefaultCacheConfiguration()).isNull();
        Assertions.assertThat((Iterable)this.manager.getCacheNames()).contains((Object[])new String[]{"small-cache"});
        Assertions.assertThat((long)this.manager.getCacheConfiguration("small-cache").memory().size()).isEqualTo(1000L);
        Assertions.assertThat((Comparable)this.manager.getCacheConfiguration("small-cache").memory().evictionType()).isEqualTo((Object)EvictionType.COUNT);
        Assertions.assertThat((Object)startedEvent).isNotNull();
    }

    @Configuration
    static class TestConfiguration {
        TestConfiguration() {
        }

        @Bean(name={"small-cache"})
        public org.infinispan.configuration.cache.Configuration smallCache() {
            return new ConfigurationBuilder().simpleCache(true).memory().size(1000L).memory().evictionType(EvictionType.COUNT).build();
        }

        @Bean
        public InfinispanCacheConfigurer cacheConfigurer() {
            return manager -> manager.addListener((Object)new ExampleListener());
        }

        @Bean
        public InfinispanGlobalConfigurationCustomizer globalCustomizer() {
            return builder -> builder.transport().clusterName(CLUSTER_NAME).jmx().disable();
        }

        @Bean
        public InfinispanConfigurationCustomizer configurationCustomizer() {
            return builder -> builder.memory().evictionType(EvictionType.COUNT);
        }

        @Listener
        public class ExampleListener {
            @CacheStarted
            public void cacheStarted(CacheStartedEvent event) {
                startedEvent = event;
            }
        }
    }
}

