/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.embedded;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.starter.embedded.InfinispanCacheConfigurer;
import org.infinispan.spring.starter.embedded.InfinispanConfigurationCustomizer;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedCacheManagerChecker;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedConfigurationProperties;
import org.infinispan.spring.starter.embedded.InfinispanGlobalConfigurationCustomizer;
import org.infinispan.spring.starter.embedded.InfinispanGlobalConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
@AutoConfigureBefore(value={CacheAutoConfiguration.class})
@ConditionalOnClass(name={"org.infinispan.manager.EmbeddedCacheManager"})
@ConditionalOnProperty(value={"infinispan.embedded.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={InfinispanEmbeddedConfigurationProperties.class})
public class InfinispanEmbeddedAutoConfiguration {
    public static final String DEFAULT_JMX_DOMAIN = "infinispan";
    @Autowired
    private InfinispanEmbeddedConfigurationProperties infinispanProperties;
    @Autowired(required=false)
    private List<InfinispanCacheConfigurer> configurers = Collections.emptyList();
    @Autowired(required=false)
    private List<InfinispanConfigurationCustomizer> configurationCustomizers = Collections.emptyList();
    @Autowired(required=false)
    private Map<String, org.infinispan.configuration.cache.Configuration> cacheConfigurations = Collections.emptyMap();
    @Autowired(required=false)
    private InfinispanGlobalConfigurer infinispanGlobalConfigurer;
    @Autowired(required=false)
    private List<InfinispanGlobalConfigurationCustomizer> globalConfigurationCustomizers = Collections.emptyList();

    @Bean(destroyMethod="stop")
    @Conditional(value={InfinispanEmbeddedCacheManagerChecker.class})
    @ConditionalOnMissingBean
    public DefaultCacheManager defaultCacheManager() throws IOException {
        DefaultCacheManager manager;
        String configXml = this.infinispanProperties.getConfigXml();
        if (!configXml.isEmpty()) {
            manager = new DefaultCacheManager(configXml);
        } else {
            GlobalConfigurationBuilder globalConfigurationBuilder = new GlobalConfigurationBuilder();
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
            if (this.infinispanGlobalConfigurer != null) {
                globalConfigurationBuilder.read(this.infinispanGlobalConfigurer.getGlobalConfiguration());
            } else {
                globalConfigurationBuilder.globalJmxStatistics().jmxDomain(DEFAULT_JMX_DOMAIN).enable();
                globalConfigurationBuilder.transport().clusterName(this.infinispanProperties.getClusterName());
            }
            this.globalConfigurationCustomizers.forEach(customizer -> customizer.cusomize(globalConfigurationBuilder));
            this.configurationCustomizers.forEach(customizer -> customizer.customize(configurationBuilder));
            manager = new DefaultCacheManager(globalConfigurationBuilder.build(), configurationBuilder.build());
        }
        this.cacheConfigurations.forEach((arg_0, arg_1) -> ((DefaultCacheManager)manager).defineConfiguration(arg_0, arg_1));
        this.configurers.forEach(configurer -> configurer.configureCache((EmbeddedCacheManager)manager));
        return manager;
    }
}

