/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.remote;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;

@org.springframework.boot.context.properties.ConfigurationProperties(value="infinispan.remote", ignoreInvalidFields=true)
public class InfinispanRemoteConfigurationProperties
extends ConfigurationProperties {
    public static final String DEFAULT_CLIENT_PROPERTIES = "classpath:hotrod-client.properties";
    private boolean enabled = true;
    private String clientProperties = "classpath:hotrod-client.properties";
    private final Map<String, String> saslProperties = new HashMap<String, String>();
    private final Map<String, String> cluster = new HashMap<String, String>();

    public String getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(String clientProperties) {
        this.clientProperties = clientProperties;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Properties properties = this.getProperties();
        this.saslProperties.forEach((k, v) -> this.getProperties().setProperty("infinispan.client.hotrod.sasl_properties." + k, (String)v));
        this.cluster.forEach((k, v) -> this.getProperties().setProperty("infinispan.client.hotrod.cluster." + k, (String)v));
        builder.withProperties(properties);
        return builder;
    }

    public Map<String, String> getSaslProperties() {
        return this.saslProperties;
    }

    public Map<String, String> getCluster() {
        return this.cluster;
    }

    public void setSslProtocol(String sslProtocol) {
        this.getProperties().setProperty("infinispan.client.hotrod.ssl_protocol", sslProtocol);
    }

    public void setAuthUserName(String authUserName) {
        super.setAuthUsername(authUserName);
    }
}

