/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.global.LegacyGlobalConfigurationAdaptor;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.ConfigurationOverrides;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.core.io.Resource;

public class AbstractEmbeddedCacheManagerFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configurationFileLocation;
    protected final GlobalConfigurationOverrides globalConfigurationOverrides = new GlobalConfigurationOverrides();
    protected final ConfigurationOverrides configurationOverrides = new ConfigurationOverrides();

    protected EmbeddedCacheManager createBackingEmbeddedCacheManager() throws ConfigurationException, IOException {
        ConfigurationContainer templateConfiguration = this.createTemplateConfiguration();
        this.globalConfigurationOverrides.applyOverridesTo(templateConfiguration.globalConfiguration);
        this.configurationOverrides.applyOverridesTo(templateConfiguration.defaultConfiguration);
        EmbeddedCacheManager nativeEmbeddedCacheManager = this.createCacheManager(templateConfiguration);
        for (Map.Entry<String, org.infinispan.config.Configuration> namedCacheConfig : templateConfiguration.namedCaches.entrySet()) {
            nativeEmbeddedCacheManager.defineConfiguration(namedCacheConfig.getKey(), namedCacheConfig.getValue());
        }
        return nativeEmbeddedCacheManager;
    }

    protected EmbeddedCacheManager createCacheManager(ConfigurationContainer templateConfiguration) {
        return new DefaultCacheManager(templateConfiguration.globalConfiguration, templateConfiguration.defaultConfiguration);
    }

    protected ConfigurationContainer createTemplateConfiguration() throws ConfigurationException, IOException {
        ConfigurationContainer templateConfiguration;
        if (this.configurationFileLocation == null) {
            this.logger.info((Object)"No configuration file has been given. Using Infinispan's default settings.");
            GlobalConfiguration standardGlobalConfiguration = new GlobalConfiguration();
            org.infinispan.config.Configuration standardDefaultConfiguration = new org.infinispan.config.Configuration();
            templateConfiguration = new ConfigurationContainer(standardGlobalConfiguration, standardDefaultConfiguration, new HashMap<String, org.infinispan.config.Configuration>());
        } else {
            this.logger.info((Object)("Using Infinispan configuration file located at [" + this.configurationFileLocation + "]"));
            templateConfiguration = this.loadConfigurationFromFile(this.configurationFileLocation);
        }
        return templateConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationContainer loadConfigurationFromFile(Resource configFileLocation) throws ConfigurationException, IOException {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader());
        InputStream configFileInputStream = configFileLocation.getInputStream();
        try {
            ConfigurationBuilderHolder parsed = parserRegistry.parse(configFileInputStream);
            ConfigurationContainer configurationContainer = new ConfigurationContainer(parsed);
            return configurationContainer;
        }
        finally {
            configFileInputStream.close();
        }
    }

    public void setConfigurationFileLocation(Resource configurationFileLocation) {
        this.configurationFileLocation = configurationFileLocation;
    }

    public void setExposeGlobalJmxStatistics(boolean exposeGlobalJmxStatistics) {
        this.globalConfigurationOverrides.exposeGlobalJmxStatistics = exposeGlobalJmxStatistics;
    }

    public void setJmxDomain(String jmxObjectName) {
        this.globalConfigurationOverrides.jmxDomain = jmxObjectName;
    }

    public void setMBeanServerProperties(Properties properties) {
        this.globalConfigurationOverrides.mBeanServerProperties = properties;
    }

    public void setMBeanServerLookupClass(String mBeanServerLookupClass) {
        this.globalConfigurationOverrides.mBeanServerLookupClass = mBeanServerLookupClass;
    }

    public void setMBeanServerLookup(MBeanServerLookup mBeanServerLookup) {
        this.globalConfigurationOverrides.mBeanServerLookup = mBeanServerLookup;
    }

    public void setAllowDuplicateDomains(boolean allowDuplicateDomains) {
        this.globalConfigurationOverrides.allowDuplicateDomains = allowDuplicateDomains;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.globalConfigurationOverrides.cacheManagerName = cacheManagerName;
    }

    public void setStrictPeerToPeer(boolean strictPeerToPeer) {
        this.globalConfigurationOverrides.strictPeerToPeer = strictPeerToPeer;
    }

    public void setAsyncListenerExecutorFactoryClass(String asyncListenerExecutorFactoryClass) {
        this.globalConfigurationOverrides.asyncListenerExecutorFactoryClass = asyncListenerExecutorFactoryClass;
    }

    public void setAsyncTransportExecutorFactoryClass(String asyncTransportExecutorFactoryClass) {
        this.globalConfigurationOverrides.asyncTransportExecutorFactoryClass = asyncTransportExecutorFactoryClass;
    }

    public void setEvictionScheduledExecutorFactoryClass(String evictionScheduledExecutorFactoryClass) {
        this.globalConfigurationOverrides.evictionScheduledExecutorFactoryClass = evictionScheduledExecutorFactoryClass;
    }

    public void setReplicationQueueScheduledExecutorFactoryClass(String replicationQueueScheduledExecutorFactoryClass) {
        this.globalConfigurationOverrides.replicationQueueScheduledExecutorFactoryClass = replicationQueueScheduledExecutorFactoryClass;
    }

    public void setMarshallerClass(String marshallerClass) {
        this.globalConfigurationOverrides.marshallerClass = marshallerClass;
    }

    public void setTransportNodeName(String nodeName) {
        this.globalConfigurationOverrides.transportNodeName = nodeName;
    }

    public void setTransportClass(String transportClass) {
        this.globalConfigurationOverrides.transportClass = transportClass;
    }

    public void setTransportProperties(Properties transportProperties) {
        this.globalConfigurationOverrides.transportProperties = transportProperties;
    }

    public void setClusterName(String clusterName) {
        this.globalConfigurationOverrides.clusterName = clusterName;
    }

    public void setMachineId(String machineId) {
        this.globalConfigurationOverrides.machineId = machineId;
    }

    public void setRackId(String rackId) {
        this.globalConfigurationOverrides.rackId = rackId;
    }

    public void setSiteId(String siteId) {
        this.globalConfigurationOverrides.siteId = siteId;
    }

    public void setShutdownHookBehavior(String shutdownHookBehavior) {
        this.globalConfigurationOverrides.shutdownHookBehavior = shutdownHookBehavior;
    }

    public void setAsyncListenerExecutorProperties(Properties asyncListenerExecutorProperties) {
        this.globalConfigurationOverrides.asyncListenerExecutorProperties = asyncListenerExecutorProperties;
    }

    public void setAsyncTransportExecutorProperties(Properties asyncTransportExecutorProperties) {
        this.globalConfigurationOverrides.asyncTransportExecutorProperties = asyncTransportExecutorProperties;
    }

    public void setEvictionScheduledExecutorProperties(Properties evictionScheduledExecutorProperties) {
        this.globalConfigurationOverrides.evictionScheduledExecutorProperties = evictionScheduledExecutorProperties;
    }

    public void setReplicationQueueScheduledExecutorProperties(Properties replicationQueueScheduledExecutorProperties) {
        this.globalConfigurationOverrides.replicationQueueScheduledExecutorProperties = replicationQueueScheduledExecutorProperties;
    }

    public void setMarshallVersion(short marshallVersion) {
        this.globalConfigurationOverrides.marshallVersion = marshallVersion;
    }

    public void setDistributedSyncTimeout(long distributedSyncTimeout) {
        this.globalConfigurationOverrides.distributedSyncTimeout = distributedSyncTimeout;
    }

    public void setDeadlockDetectionSpinDuration(Long eagerDeadlockSpinDuration) {
        this.configurationOverrides.setDeadlockDetectionSpinDuration(eagerDeadlockSpinDuration);
    }

    public void setEnableDeadlockDetection(Boolean useEagerDeadlockDetection) {
        this.configurationOverrides.setEnableDeadlockDetection(useEagerDeadlockDetection);
    }

    public void setUseLockStriping(Boolean useLockStriping) {
        this.configurationOverrides.setUseLockStriping(useLockStriping);
    }

    public void setUnsafeUnreliableReturnValues(Boolean unsafeUnreliableReturnValues) {
        this.configurationOverrides.setUnsafeUnreliableReturnValues(unsafeUnreliableReturnValues);
    }

    public void setRehashRpcTimeout(Long rehashRpcTimeout) {
        this.configurationOverrides.setRehashRpcTimeout(rehashRpcTimeout);
    }

    public void setWriteSkewCheck(Boolean writeSkewCheck) {
        this.configurationOverrides.setWriteSkewCheck(writeSkewCheck);
    }

    public void setConcurrencyLevel(Integer concurrencyLevel) {
        this.configurationOverrides.setConcurrencyLevel(concurrencyLevel);
    }

    public void setReplQueueMaxElements(Integer replQueueMaxElements) {
        this.configurationOverrides.setReplQueueMaxElements(replQueueMaxElements);
    }

    public void setReplQueueInterval(Long replQueueInterval) {
        this.configurationOverrides.setReplQueueInterval(replQueueInterval);
    }

    public void setReplQueueClass(String replQueueClass) {
        this.configurationOverrides.setReplQueueClass(replQueueClass);
    }

    public void setExposeJmxStatistics(Boolean exposeJmxStatistics) {
        this.configurationOverrides.setExposeJmxStatistics(exposeJmxStatistics);
    }

    public void setInvocationBatchingEnabled(Boolean invocationBatchingEnabled) {
        this.configurationOverrides.setInvocationBatchingEnabled(invocationBatchingEnabled);
    }

    public void setFetchInMemoryState(Boolean fetchInMemoryState) {
        this.configurationOverrides.setFetchInMemoryState(fetchInMemoryState);
    }

    public void setAlwaysProvideInMemoryState(Boolean alwaysProvideInMemoryState) {
        this.configurationOverrides.setAlwaysProvideInMemoryState(alwaysProvideInMemoryState);
    }

    public void setLockAcquisitionTimeout(Long lockAcquisitionTimeout) {
        this.configurationOverrides.setLockAcquisitionTimeout(lockAcquisitionTimeout);
    }

    public void setSyncReplTimeout(Long syncReplTimeout) {
        this.configurationOverrides.setSyncReplTimeout(syncReplTimeout);
    }

    public void setCacheModeString(String cacheModeString) {
        this.configurationOverrides.setCacheModeString(cacheModeString);
    }

    public void setExpirationWakeUpInterval(Long expirationWakeUpInterval) {
        this.configurationOverrides.setExpirationWakeUpInterval(expirationWakeUpInterval);
    }

    public void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.configurationOverrides.setEvictionStrategy(evictionStrategy);
    }

    public void setEvictionStrategyClass(String evictionStrategyClass) {
        this.configurationOverrides.setEvictionStrategyClass(evictionStrategyClass);
    }

    public void setEvictionThreadPolicy(EvictionThreadPolicy evictionThreadPolicy) {
        this.configurationOverrides.setEvictionThreadPolicy(evictionThreadPolicy);
    }

    public void setEvictionThreadPolicyClass(String evictionThreadPolicyClass) {
        this.configurationOverrides.setEvictionThreadPolicyClass(evictionThreadPolicyClass);
    }

    public void setEvictionMaxEntries(Integer evictionMaxEntries) {
        this.configurationOverrides.setEvictionMaxEntries(evictionMaxEntries);
    }

    public void setExpirationLifespan(Long expirationLifespan) {
        this.configurationOverrides.setExpirationLifespan(expirationLifespan);
    }

    public void setExpirationMaxIdle(Long expirationMaxIdle) {
        this.configurationOverrides.setExpirationMaxIdle(expirationMaxIdle);
    }

    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.configurationOverrides.setTransactionManagerLookupClass(transactionManagerLookupClass);
    }

    public void setTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.configurationOverrides.setTransactionManagerLookup(transactionManagerLookup);
    }

    public void setCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        this.configurationOverrides.setCacheLoaderManagerConfig(cacheLoaderManagerConfig);
    }

    public void setSyncCommitPhase(Boolean syncCommitPhase) {
        this.configurationOverrides.setSyncCommitPhase(syncCommitPhase);
    }

    public void setSyncRollbackPhase(Boolean syncRollbackPhase) {
        this.configurationOverrides.setSyncRollbackPhase(syncRollbackPhase);
    }

    public void setUseEagerLocking(Boolean useEagerLocking) {
        this.configurationOverrides.setUseEagerLocking(useEagerLocking);
    }

    public void setEagerLockSingleNode(Boolean eagerLockSingleNode) {
        this.configurationOverrides.setEagerLockSingleNode(eagerLockSingleNode);
    }

    public void setUseReplQueue(Boolean useReplQueue) {
        this.configurationOverrides.setUseReplQueue(useReplQueue);
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.configurationOverrides.setIsolationLevel(isolationLevel);
    }

    public void setStateRetrievalTimeout(Long stateRetrievalTimeout) {
        this.configurationOverrides.setStateRetrievalTimeout(stateRetrievalTimeout);
    }

    public void setStateRetrievalLogFlushTimeout(Long stateRetrievalLogFlushTimeout) {
        this.configurationOverrides.setStateRetrievalLogFlushTimeout(stateRetrievalLogFlushTimeout);
    }

    public void setStateRetrievalMaxNonProgressingLogWrites(Integer stateRetrievalMaxNonProgressingLogWrites) {
        this.configurationOverrides.setStateRetrievalMaxNonProgressingLogWrites(stateRetrievalMaxNonProgressingLogWrites);
    }

    public void setStateRetrievalInitialRetryWaitTime(Long stateRetrievalInitialRetryWaitTime) {
        this.configurationOverrides.setStateRetrievalInitialRetryWaitTime(stateRetrievalInitialRetryWaitTime);
    }

    public void setStateRetrievalRetryWaitTimeIncreaseFactor(Integer stateRetrievalRetryWaitTimeIncreaseFactor) {
        this.configurationOverrides.setStateRetrievalRetryWaitTimeIncreaseFactor(stateRetrievalRetryWaitTimeIncreaseFactor);
    }

    public void setStateRetrievalChunkSize(Integer stateRetrievalChunkSize) {
        this.configurationOverrides.setStateRetrievalChunkSize(stateRetrievalChunkSize);
    }

    public void setStateRetrievalNumRetries(Integer stateRetrievalNumRetries) {
        this.configurationOverrides.setStateRetrievalNumRetries(stateRetrievalNumRetries);
    }

    public void setIsolationLevelClass(String isolationLevelClass) {
        this.configurationOverrides.setIsolationLevelClass(isolationLevelClass);
    }

    public void setUseLazyDeserialization(Boolean useLazyDeserialization) {
        this.configurationOverrides.setUseLazyDeserialization(useLazyDeserialization);
    }

    public void setL1CacheEnabled(Boolean l1CacheEnabled) {
        this.configurationOverrides.setL1CacheEnabled(l1CacheEnabled);
    }

    public void setL1Lifespan(Long l1Lifespan) {
        this.configurationOverrides.setL1Lifespan(l1Lifespan);
    }

    public void setL1OnRehash(Boolean l1OnRehash) {
        this.configurationOverrides.setL1OnRehash(l1OnRehash);
    }

    public void setConsistentHashClass(String consistentHashClass) {
        this.configurationOverrides.setConsistentHashClass(consistentHashClass);
    }

    public void setNumOwners(Integer numOwners) {
        this.configurationOverrides.setNumOwners(numOwners);
    }

    public void setRehashEnabled(Boolean rehashEnabled) {
        this.configurationOverrides.setRehashEnabled(rehashEnabled);
    }

    public void setRehashWaitTime(Long rehashWaitTime) {
        this.configurationOverrides.setRehashWaitTime(rehashWaitTime);
    }

    public void setUseAsyncMarshalling(Boolean useAsyncMarshalling) {
        this.configurationOverrides.setUseAsyncMarshalling(useAsyncMarshalling);
    }

    public void setIndexingEnabled(Boolean indexingEnabled) {
        this.configurationOverrides.setIndexingEnabled(indexingEnabled);
    }

    public void setIndexLocalOnly(Boolean indexLocalOnly) {
        this.configurationOverrides.setIndexLocalOnly(indexLocalOnly);
    }

    public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
        this.configurationOverrides.setCustomInterceptors(customInterceptors);
    }

    protected static final class GlobalConfigurationOverrides {
        private final Log logger = LogFactory.getLog(this.getClass());
        private Boolean exposeGlobalJmxStatistics;
        private Properties mBeanServerProperties;
        private String jmxDomain;
        private String mBeanServerLookupClass;
        private MBeanServerLookup mBeanServerLookup;
        private Boolean allowDuplicateDomains;
        private String cacheManagerName;
        private String clusterName;
        private String machineId;
        private String rackId;
        private String siteId;
        private Boolean strictPeerToPeer;
        private Long distributedSyncTimeout;
        private String transportClass;
        private String transportNodeName;
        private String asyncListenerExecutorFactoryClass;
        private String asyncTransportExecutorFactoryClass;
        private String evictionScheduledExecutorFactoryClass;
        private String replicationQueueScheduledExecutorFactoryClass;
        private String marshallerClass;
        private Properties transportProperties;
        private String shutdownHookBehavior;
        private Properties asyncListenerExecutorProperties;
        private Properties asyncTransportExecutorProperties;
        private Properties evictionScheduledExecutorProperties;
        private Properties replicationQueueScheduledExecutorProperties;
        private Short marshallVersion;

        protected GlobalConfigurationOverrides() {
        }

        public void applyOverridesTo(GlobalConfiguration globalConfigurationToOverride) {
            this.logger.debug((Object)("Applying configuration overrides to GlobalConfiguration [" + globalConfigurationToOverride + "] ..."));
            if (this.exposeGlobalJmxStatistics != null) {
                this.logger.debug((Object)("Overriding property [exposeGlobalJmxStatistics] with new value [" + this.exposeGlobalJmxStatistics + "]"));
                globalConfigurationToOverride.setExposeGlobalJmxStatistics(this.exposeGlobalJmxStatistics.booleanValue());
            }
            if (this.mBeanServerProperties != null) {
                this.logger.debug((Object)("Overriding property [mBeanServerProperties] with new value [" + this.mBeanServerProperties + "]"));
                globalConfigurationToOverride.setMBeanServerProperties(this.mBeanServerProperties);
            }
            if (this.jmxDomain != null) {
                this.logger.debug((Object)("Overriding property [jmxDomain] with new value [" + this.jmxDomain + "]"));
                globalConfigurationToOverride.setJmxDomain(this.jmxDomain);
            }
            if (this.mBeanServerLookupClass != null) {
                this.logger.debug((Object)("Overriding property [mBeanServerLookupClass] with new value [" + this.mBeanServerLookupClass + "]"));
                globalConfigurationToOverride.setMBeanServerLookup(this.mBeanServerLookupClass);
            }
            if (this.mBeanServerLookup != null) {
                this.logger.debug((Object)("Overriding property [mBeanServerLookup] with new value [" + this.mBeanServerLookup + "]"));
                globalConfigurationToOverride.setMBeanServerLookup(this.mBeanServerLookup);
            }
            if (this.allowDuplicateDomains != null) {
                this.logger.debug((Object)("Overriding property [allowDuplicateDomains] with new value [" + this.allowDuplicateDomains + "]"));
                globalConfigurationToOverride.setAllowDuplicateDomains(this.allowDuplicateDomains.booleanValue());
            }
            if (this.cacheManagerName != null) {
                this.logger.debug((Object)("Overriding property [cacheManagerName] with new value [" + this.cacheManagerName + "]"));
                globalConfigurationToOverride.setCacheManagerName(this.cacheManagerName);
            }
            if (this.clusterName != null) {
                this.logger.debug((Object)("Overriding property [clusterName] with new value [" + this.clusterName + "]"));
                globalConfigurationToOverride.setClusterName(this.clusterName);
            }
            if (this.machineId != null) {
                this.logger.debug((Object)("Overriding property [machineId] with new value [" + this.machineId + "]"));
                globalConfigurationToOverride.setMachineId(this.machineId);
            }
            if (this.rackId != null) {
                this.logger.debug((Object)("Overriding property [rackId] with new value [" + this.rackId + "]"));
                globalConfigurationToOverride.setRackId(this.rackId);
            }
            if (this.siteId != null) {
                this.logger.debug((Object)("Overriding property [siteId] with new value [" + this.siteId + "]"));
                globalConfigurationToOverride.setSiteId(this.siteId);
            }
            if (this.strictPeerToPeer != null) {
                this.logger.debug((Object)("Overriding property [strictPeerToPeer] with new value [" + this.strictPeerToPeer + "]"));
                globalConfigurationToOverride.setStrictPeerToPeer(this.strictPeerToPeer.booleanValue());
            }
            if (this.distributedSyncTimeout != null) {
                this.logger.debug((Object)("Overriding property [distributedSyncTimeout] with new value [" + this.distributedSyncTimeout + "]"));
                globalConfigurationToOverride.setDistributedSyncTimeout(this.distributedSyncTimeout.longValue());
            }
            if (this.transportClass != null) {
                this.logger.debug((Object)("Overriding property [transportClass] with new value [" + this.transportClass + "]"));
                globalConfigurationToOverride.setTransportClass(this.transportClass);
            }
            if (this.transportNodeName != null) {
                this.logger.debug((Object)("Overriding property [transportNodeName] with new value [" + this.transportNodeName + "]"));
                globalConfigurationToOverride.setTransportNodeName(this.transportNodeName);
            }
            if (this.asyncListenerExecutorFactoryClass != null) {
                this.logger.debug((Object)("Overriding property [asyncListenerExecutorFactoryClass] with new value [" + this.asyncListenerExecutorFactoryClass + "]"));
                globalConfigurationToOverride.setAsyncListenerExecutorFactoryClass(this.asyncListenerExecutorFactoryClass);
            }
            if (this.asyncTransportExecutorFactoryClass != null) {
                this.logger.debug((Object)("Overriding property [asyncTransportExecutorFactoryClass] with new value [" + this.asyncTransportExecutorFactoryClass + "]"));
                globalConfigurationToOverride.setAsyncTransportExecutorFactoryClass(this.asyncTransportExecutorFactoryClass);
            }
            if (this.evictionScheduledExecutorFactoryClass != null) {
                this.logger.debug((Object)("Overriding property [evictionScheduledExecutorFactoryClass] with new value [" + this.evictionScheduledExecutorFactoryClass + "]"));
                globalConfigurationToOverride.setEvictionScheduledExecutorFactoryClass(this.evictionScheduledExecutorFactoryClass);
            }
            if (this.replicationQueueScheduledExecutorFactoryClass != null) {
                this.logger.debug((Object)("Overriding property [replicationQueueScheduledExecutorFactoryClass] with new value [" + this.replicationQueueScheduledExecutorFactoryClass + "]"));
                globalConfigurationToOverride.setReplicationQueueScheduledExecutorFactoryClass(this.replicationQueueScheduledExecutorFactoryClass);
            }
            if (this.marshallerClass != null) {
                this.logger.debug((Object)("Overriding property [marshallerClass] with new value [" + this.marshallerClass + "]"));
                globalConfigurationToOverride.setMarshallerClass(this.marshallerClass);
            }
            if (this.transportProperties != null) {
                this.logger.debug((Object)("Overriding property [transportProperties] with new value [" + this.transportProperties + "]"));
                globalConfigurationToOverride.setTransportProperties(this.transportProperties);
            }
            if (this.shutdownHookBehavior != null) {
                this.logger.debug((Object)("Overriding property [shutdownHookBehavior] with new value [" + this.shutdownHookBehavior + "]"));
                globalConfigurationToOverride.setShutdownHookBehavior(this.shutdownHookBehavior);
            }
            if (this.asyncListenerExecutorProperties != null) {
                this.logger.debug((Object)("Overriding property [asyncListenerExecutorProperties] with new value [" + this.asyncListenerExecutorProperties + "]"));
                globalConfigurationToOverride.setAsyncListenerExecutorProperties(this.asyncListenerExecutorProperties);
            }
            if (this.asyncTransportExecutorProperties != null) {
                this.logger.debug((Object)("Overriding property [asyncTransportExecutorProperties] with new value [" + this.asyncTransportExecutorProperties + "]"));
                globalConfigurationToOverride.setAsyncTransportExecutorProperties(this.asyncTransportExecutorProperties);
            }
            if (this.evictionScheduledExecutorProperties != null) {
                this.logger.debug((Object)("Overriding property [evictionScheduledExecutorProperties] with new value [" + this.evictionScheduledExecutorProperties + "]"));
                globalConfigurationToOverride.setEvictionScheduledExecutorProperties(this.evictionScheduledExecutorProperties);
            }
            if (this.replicationQueueScheduledExecutorProperties != null) {
                this.logger.debug((Object)("Overriding property [replicationQueueScheduledExecutorProperties] with new value [" + this.replicationQueueScheduledExecutorProperties + "]"));
                globalConfigurationToOverride.setReplicationQueueScheduledExecutorProperties(this.replicationQueueScheduledExecutorProperties);
            }
            if (this.marshallVersion != null) {
                this.logger.debug((Object)("Overriding property [marshallVersion] with new value [" + this.marshallVersion + "]"));
                globalConfigurationToOverride.fluent().serialization().version(this.marshallVersion.shortValue());
            }
            this.logger.debug((Object)("Finished applying configuration overrides to GlobalConfiguration [" + globalConfigurationToOverride + "]"));
        }
    }

    protected static final class ConfigurationContainer {
        public final GlobalConfiguration globalConfiguration;
        public final org.infinispan.config.Configuration defaultConfiguration;
        public final Map<String, org.infinispan.config.Configuration> namedCaches;

        ConfigurationContainer(GlobalConfiguration globalConfiguration, org.infinispan.config.Configuration defaultConfiguration, Map<String, org.infinispan.config.Configuration> namedCaches) {
            this.globalConfiguration = globalConfiguration.clone();
            this.defaultConfiguration = defaultConfiguration.clone();
            this.namedCaches = Collections.unmodifiableMap(namedCaches);
        }

        ConfigurationContainer(ConfigurationBuilderHolder parsed) {
            this(LegacyGlobalConfigurationAdaptor.adapt((org.infinispan.configuration.global.GlobalConfiguration)parsed.getGlobalConfigurationBuilder().build()), LegacyConfigurationAdaptor.adapt((Configuration)parsed.getDefaultConfigurationBuilder().build()), ConfigurationContainer.extractNamedCfgs(parsed));
        }

        private static Map<String, org.infinispan.config.Configuration> extractNamedCfgs(ConfigurationBuilderHolder parsed) {
            Map ncbs = parsed.getNamedConfigurationBuilders();
            HashMap<String, org.infinispan.config.Configuration> namedCfgs = new HashMap<String, org.infinispan.config.Configuration>(ncbs.size());
            for (Map.Entry entry : ncbs.entrySet()) {
                namedCfgs.put((String)entry.getKey(), LegacyConfigurationAdaptor.adapt((Configuration)((ConfigurationBuilder)entry.getValue()).build()));
            }
            return namedCfgs;
        }
    }
}

