/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.api.BasicCache;
import org.infinispan.spring.provider.NullValue;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class SpringCache
implements Cache {
    private final BasicCache<Object, Object> nativeCache;

    public SpringCache(BasicCache<Object, Object> nativeCache) {
        Assert.notNull(nativeCache, (String)"A non-null Infinispan cache implementation is required");
        this.nativeCache = nativeCache;
    }

    public String getName() {
        return this.nativeCache.getName();
    }

    public BasicCache<?, ?> getNativeCache() {
        return this.nativeCache;
    }

    public Cache.ValueWrapper get(Object key) {
        Object v = this.nativeCache.get(key);
        if (v == null) {
            return null;
        }
        if (v == NullValue.NULL) {
            return NullValue.NULL;
        }
        return new SimpleValueWrapper(v);
    }

    public void put(Object key, Object value) {
        this.nativeCache.put(key, value != null ? value : NullValue.NULL);
    }

    public void evict(Object key) {
        this.nativeCache.remove(key);
    }

    public void clear() {
        this.nativeCache.clear();
    }

    public String toString() {
        return "InfinispanCache [nativeCache = " + this.nativeCache + "]";
    }
}

