/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.ConfigurationOverrides;
import org.infinispan.spring.GlobalConfigurationOverrides;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.core.io.Resource;

public class AbstractEmbeddedCacheManagerFactory {
    protected static final Log logger = LogFactory.getLog(AbstractEmbeddedCacheManagerFactory.class);
    private Resource configurationFileLocation;
    protected final GlobalConfigurationOverrides globalConfigurationOverrides = new GlobalConfigurationOverrides();
    protected final ConfigurationOverrides configurationOverrides = new ConfigurationOverrides();

    protected EmbeddedCacheManager createBackingEmbeddedCacheManager() throws IOException {
        if (this.configurationFileLocation != null) {
            return this.createCacheManager(this.configurationFileLocation.getInputStream());
        }
        GlobalConfigurationBuilder globalCfgBuilder = new GlobalConfigurationBuilder();
        ConfigurationBuilder cacheCfgBuilder = new ConfigurationBuilder();
        this.globalConfigurationOverrides.applyOverridesTo(globalCfgBuilder);
        this.configurationOverrides.applyOverridesTo(cacheCfgBuilder);
        EmbeddedCacheManager cm = this.createCacheManager(globalCfgBuilder, cacheCfgBuilder);
        return cm;
    }

    protected EmbeddedCacheManager createCacheManager(InputStream is) throws IOException {
        return new DefaultCacheManager(is);
    }

    protected EmbeddedCacheManager createCacheManager(GlobalConfigurationBuilder globalBuilder, ConfigurationBuilder builder) {
        return new DefaultCacheManager(globalBuilder.build(), builder.build());
    }

    public void setConfigurationFileLocation(Resource configurationFileLocation) {
        this.configurationFileLocation = configurationFileLocation;
    }

    public void setExposeGlobalJmxStatistics(boolean exposeGlobalJmxStatistics) {
        this.globalConfigurationOverrides.setExposeGlobalJmxStatistics(exposeGlobalJmxStatistics);
    }

    public void setJmxDomain(String jmxObjectName) {
        this.globalConfigurationOverrides.setJmxDomain(jmxObjectName);
    }

    public void setMBeanServerProperties(Properties properties) {
        this.globalConfigurationOverrides.setmBeanServerProperties(properties);
    }

    public void setMBeanServerLookupClass(String mBeanServerLookupClass) {
        this.globalConfigurationOverrides.setmBeanServerLookupClass(mBeanServerLookupClass);
    }

    public void setMBeanServerLookup(MBeanServerLookup mBeanServerLookup) {
        this.globalConfigurationOverrides.setmBeanServerLookup(mBeanServerLookup);
    }

    public void setAllowDuplicateDomains(boolean allowDuplicateDomains) {
        this.globalConfigurationOverrides.setAllowDuplicateDomains(allowDuplicateDomains);
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.globalConfigurationOverrides.setCacheManagerName(cacheManagerName);
    }

    public void setStrictPeerToPeer(boolean strictPeerToPeer) {
        this.globalConfigurationOverrides.setStrictPeerToPeer(strictPeerToPeer);
    }

    public void setAsyncListenerExecutorFactoryClass(String asyncListenerExecutorFactoryClass) {
        this.globalConfigurationOverrides.setAsyncListenerExecutorFactoryClass(asyncListenerExecutorFactoryClass);
    }

    public void setAsyncTransportExecutorFactoryClass(String asyncTransportExecutorFactoryClass) {
        this.globalConfigurationOverrides.setAsyncTransportExecutorFactoryClass(asyncTransportExecutorFactoryClass);
    }

    public void setRemoteCommandsExecutorFactoryClass(String remoteCommandsExecutorFactoryClass) {
        this.globalConfigurationOverrides.setRemoteCommandsExecutorFactoryClass(remoteCommandsExecutorFactoryClass);
    }

    public void setEvictionScheduledExecutorFactoryClass(String evictionScheduledExecutorFactoryClass) {
        this.globalConfigurationOverrides.setEvictionScheduledExecutorFactoryClass(evictionScheduledExecutorFactoryClass);
    }

    public void setReplicationQueueScheduledExecutorFactoryClass(String replicationQueueScheduledExecutorFactoryClass) {
        this.globalConfigurationOverrides.setReplicationQueueScheduledExecutorFactoryClass(replicationQueueScheduledExecutorFactoryClass);
    }

    public void setMarshallerClass(String marshallerClass) {
        this.globalConfigurationOverrides.setMarshallerClass(marshallerClass);
    }

    public void setTransportNodeName(String nodeName) {
        this.globalConfigurationOverrides.setTransportNodeName(nodeName);
    }

    public void setTransportClass(String transportClass) {
        this.globalConfigurationOverrides.setTransportClass(transportClass);
    }

    public void setTransportProperties(Properties transportProperties) {
        this.globalConfigurationOverrides.setTransportProperties(transportProperties);
    }

    public void setClusterName(String clusterName) {
        this.globalConfigurationOverrides.setClusterName(clusterName);
    }

    public void setMachineId(String machineId) {
        this.globalConfigurationOverrides.setMachineId(machineId);
    }

    public void setRackId(String rackId) {
        this.globalConfigurationOverrides.setRackId(rackId);
    }

    public void setSiteId(String siteId) {
        this.globalConfigurationOverrides.setSiteId(siteId);
    }

    public void setShutdownHookBehavior(String shutdownHookBehavior) {
        this.globalConfigurationOverrides.setShutdownHookBehavior(shutdownHookBehavior);
    }

    public void setAsyncListenerExecutorProperties(Properties asyncListenerExecutorProperties) {
        this.globalConfigurationOverrides.setAsyncListenerExecutorProperties(asyncListenerExecutorProperties);
    }

    public void setAsyncTransportExecutorProperties(Properties asyncTransportExecutorProperties) {
        this.globalConfigurationOverrides.setAsyncTransportExecutorProperties(asyncTransportExecutorProperties);
    }

    public void setRemoteCommandsExecutorProperties(Properties remoteCommandsExecutorProperties) {
        this.globalConfigurationOverrides.setRemoteCommandsExecutorProperties(remoteCommandsExecutorProperties);
    }

    public void setEvictionScheduledExecutorProperties(Properties evictionScheduledExecutorProperties) {
        this.globalConfigurationOverrides.setEvictionScheduledExecutorProperties(evictionScheduledExecutorProperties);
    }

    public void setReplicationQueueScheduledExecutorProperties(Properties replicationQueueScheduledExecutorProperties) {
        this.globalConfigurationOverrides.setReplicationQueueScheduledExecutorProperties(replicationQueueScheduledExecutorProperties);
    }

    public void setMarshallVersion(short marshallVersion) {
        this.globalConfigurationOverrides.setMarshallVersion(marshallVersion);
    }

    public void setDistributedSyncTimeout(long distributedSyncTimeout) {
        this.globalConfigurationOverrides.setDistributedSyncTimeout(distributedSyncTimeout);
    }

    public void setDeadlockDetectionSpinDuration(Long eagerDeadlockSpinDuration) {
        this.configurationOverrides.setDeadlockDetectionSpinDuration(eagerDeadlockSpinDuration);
    }

    public void setEnableDeadlockDetection(Boolean useEagerDeadlockDetection) {
        this.configurationOverrides.setEnableDeadlockDetection(useEagerDeadlockDetection);
    }

    public void setUseLockStriping(Boolean useLockStriping) {
        this.configurationOverrides.setUseLockStriping(useLockStriping);
    }

    public void setUnsafeUnreliableReturnValues(Boolean unsafeUnreliableReturnValues) {
        this.configurationOverrides.setUnsafeUnreliableReturnValues(unsafeUnreliableReturnValues);
    }

    public void setRehashRpcTimeout(Long rehashRpcTimeout) {
        this.configurationOverrides.setRehashRpcTimeout(rehashRpcTimeout);
    }

    public void setWriteSkewCheck(Boolean writeSkewCheck) {
        this.configurationOverrides.setWriteSkewCheck(writeSkewCheck);
    }

    public void setConcurrencyLevel(Integer concurrencyLevel) {
        this.configurationOverrides.setConcurrencyLevel(concurrencyLevel);
    }

    public void setReplQueueMaxElements(Integer replQueueMaxElements) {
        this.configurationOverrides.setReplQueueMaxElements(replQueueMaxElements);
    }

    public void setReplQueueInterval(Long replQueueInterval) {
        this.configurationOverrides.setReplQueueInterval(replQueueInterval);
    }

    public void setReplQueueClass(String replQueueClass) {
        this.configurationOverrides.setReplQueueClass(replQueueClass);
    }

    public void setExposeJmxStatistics(Boolean exposeJmxStatistics) {
        this.configurationOverrides.setExposeJmxStatistics(exposeJmxStatistics);
    }

    public void setInvocationBatchingEnabled(Boolean invocationBatchingEnabled) {
        this.configurationOverrides.setInvocationBatchingEnabled(invocationBatchingEnabled);
    }

    public void setFetchInMemoryState(Boolean fetchInMemoryState) {
        this.configurationOverrides.setFetchInMemoryState(fetchInMemoryState);
    }

    public void setAlwaysProvideInMemoryState(Boolean alwaysProvideInMemoryState) {
        this.configurationOverrides.setAlwaysProvideInMemoryState(alwaysProvideInMemoryState);
    }

    public void setLockAcquisitionTimeout(Long lockAcquisitionTimeout) {
        this.configurationOverrides.setLockAcquisitionTimeout(lockAcquisitionTimeout);
    }

    public void setSyncReplTimeout(Long syncReplTimeout) {
        this.configurationOverrides.setSyncReplTimeout(syncReplTimeout);
    }

    public void setCacheModeString(String cacheModeString) {
        this.configurationOverrides.setCacheModeString(cacheModeString);
    }

    public void setExpirationWakeUpInterval(Long expirationWakeUpInterval) {
        this.configurationOverrides.setExpirationWakeUpInterval(expirationWakeUpInterval);
    }

    public void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.configurationOverrides.setEvictionStrategy(evictionStrategy);
    }

    public void setEvictionStrategyClass(String evictionStrategyClass) {
        this.configurationOverrides.setEvictionStrategyClass(evictionStrategyClass);
    }

    public void setEvictionThreadPolicy(EvictionThreadPolicy evictionThreadPolicy) {
        this.configurationOverrides.setEvictionThreadPolicy(evictionThreadPolicy);
    }

    public void setEvictionThreadPolicyClass(String evictionThreadPolicyClass) {
        this.configurationOverrides.setEvictionThreadPolicyClass(evictionThreadPolicyClass);
    }

    public void setEvictionMaxEntries(Integer evictionMaxEntries) {
        this.configurationOverrides.setEvictionMaxEntries(evictionMaxEntries);
    }

    public void setExpirationLifespan(Long expirationLifespan) {
        this.configurationOverrides.setExpirationLifespan(expirationLifespan);
    }

    public void setExpirationMaxIdle(Long expirationMaxIdle) {
        this.configurationOverrides.setExpirationMaxIdle(expirationMaxIdle);
    }

    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.configurationOverrides.setTransactionManagerLookupClass(transactionManagerLookupClass);
    }

    public void setTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.configurationOverrides.setTransactionManagerLookup(transactionManagerLookup);
    }

    public void setSyncCommitPhase(Boolean syncCommitPhase) {
        this.configurationOverrides.setSyncCommitPhase(syncCommitPhase);
    }

    public void setSyncRollbackPhase(Boolean syncRollbackPhase) {
        this.configurationOverrides.setSyncRollbackPhase(syncRollbackPhase);
    }

    public void setUseEagerLocking(Boolean useEagerLocking) {
        this.configurationOverrides.setUseEagerLocking(useEagerLocking);
    }

    public void setUseReplQueue(Boolean useReplQueue) {
        this.configurationOverrides.setUseReplQueue(useReplQueue);
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.configurationOverrides.setIsolationLevel(isolationLevel);
    }

    public void setStateRetrievalTimeout(Long stateRetrievalTimeout) {
        this.configurationOverrides.setStateRetrievalTimeout(stateRetrievalTimeout);
    }

    public void setStateRetrievalMaxNonProgressingLogWrites(Integer stateRetrievalMaxNonProgressingLogWrites) {
        this.configurationOverrides.setStateRetrievalMaxNonProgressingLogWrites(stateRetrievalMaxNonProgressingLogWrites);
    }

    public void setStateRetrievalInitialRetryWaitTime(Long stateRetrievalInitialRetryWaitTime) {
        this.configurationOverrides.setStateRetrievalInitialRetryWaitTime(stateRetrievalInitialRetryWaitTime);
    }

    public void setStateRetrievalChunkSize(Integer stateRetrievalChunkSize) {
        this.configurationOverrides.setStateRetrievalChunkSize(stateRetrievalChunkSize);
    }

    public void setIsolationLevelClass(String isolationLevelClass) {
        this.configurationOverrides.setIsolationLevelClass(isolationLevelClass);
    }

    public void setUseLazyDeserialization(Boolean useLazyDeserialization) {
        this.configurationOverrides.setUseLazyDeserialization(useLazyDeserialization);
    }

    public void setL1CacheEnabled(Boolean l1CacheEnabled) {
        this.configurationOverrides.setL1CacheEnabled(l1CacheEnabled);
    }

    public void setL1Lifespan(Long l1Lifespan) {
        this.configurationOverrides.setL1Lifespan(l1Lifespan);
    }

    public void setL1OnRehash(Boolean l1OnRehash) {
        this.configurationOverrides.setL1OnRehash(l1OnRehash);
    }

    public void setConsistentHashClass(String consistentHashClass) {
        this.configurationOverrides.setConsistentHashClass(consistentHashClass);
    }

    public void setNumOwners(Integer numOwners) {
        this.configurationOverrides.setNumOwners(numOwners);
    }

    public void setRehashEnabled(Boolean rehashEnabled) {
        this.configurationOverrides.setRehashEnabled(rehashEnabled);
    }

    public void setUseAsyncMarshalling(Boolean useAsyncMarshalling) {
        this.configurationOverrides.setUseAsyncMarshalling(useAsyncMarshalling);
    }

    public void setIndexingEnabled(Boolean indexingEnabled) {
        this.configurationOverrides.setIndexingEnabled(indexingEnabled);
    }

    public void setIndexLocalOnly(Boolean indexLocalOnly) {
        this.configurationOverrides.setIndexLocalOnly(indexLocalOnly);
    }

    public void setCustomInterceptors(List<? extends CommandInterceptor> customInterceptors) {
        this.configurationOverrides.setCustomInterceptors(customInterceptors);
    }
}

