/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.util.Properties;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GlobalConfigurationOverrides {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Boolean exposeGlobalJmxStatistics;
    private Properties mBeanServerProperties;
    private String jmxDomain;
    private String mBeanServerLookupClass;
    private MBeanServerLookup mBeanServerLookup;
    private Boolean allowDuplicateDomains;
    private String cacheManagerName;
    private String clusterName;
    private String machineId;
    private String rackId;
    private String siteId;
    private Boolean strictPeerToPeer;
    private Long distributedSyncTimeout;
    private String transportClass;
    private String transportNodeName;
    private String asyncListenerExecutorFactoryClass;
    private String asyncTransportExecutorFactoryClass;
    private String remoteCommandsExecutorFactoryClass;
    private String evictionScheduledExecutorFactoryClass;
    private String replicationQueueScheduledExecutorFactoryClass;
    private String marshallerClass;
    private Properties transportProperties;
    private String shutdownHookBehavior;
    private Properties asyncListenerExecutorProperties;
    private Properties asyncTransportExecutorProperties;
    private Properties remoteCommandsExecutorProperties;
    private Properties evictionScheduledExecutorProperties;
    private Properties replicationQueueScheduledExecutorProperties;
    private Short marshallVersion;

    public void setExposeGlobalJmxStatistics(Boolean exposeGlobalJmxStatistics) {
        this.exposeGlobalJmxStatistics = exposeGlobalJmxStatistics;
    }

    public void setmBeanServerProperties(Properties mBeanServerProperties) {
        this.mBeanServerProperties = mBeanServerProperties;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public void setmBeanServerLookupClass(String mBeanServerLookupClass) {
        this.mBeanServerLookupClass = mBeanServerLookupClass;
    }

    public void setmBeanServerLookup(MBeanServerLookup mBeanServerLookup) {
        this.mBeanServerLookup = mBeanServerLookup;
    }

    public void setAllowDuplicateDomains(Boolean allowDuplicateDomains) {
        this.allowDuplicateDomains = allowDuplicateDomains;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public void setRackId(String rackId) {
        this.rackId = rackId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setStrictPeerToPeer(Boolean strictPeerToPeer) {
        this.strictPeerToPeer = strictPeerToPeer;
    }

    public void setDistributedSyncTimeout(Long distributedSyncTimeout) {
        this.distributedSyncTimeout = distributedSyncTimeout;
    }

    public void setTransportClass(String transportClass) {
        this.transportClass = transportClass;
    }

    public void setTransportNodeName(String transportNodeName) {
        this.transportNodeName = transportNodeName;
    }

    public void setAsyncListenerExecutorFactoryClass(String asyncListenerExecutorFactoryClass) {
        this.asyncListenerExecutorFactoryClass = asyncListenerExecutorFactoryClass;
    }

    public void setAsyncTransportExecutorFactoryClass(String asyncTransportExecutorFactoryClass) {
        this.asyncTransportExecutorFactoryClass = asyncTransportExecutorFactoryClass;
    }

    public void setRemoteCommandsExecutorFactoryClass(String remoteCommandsExecutorFactoryClass) {
        this.remoteCommandsExecutorFactoryClass = remoteCommandsExecutorFactoryClass;
    }

    public void setEvictionScheduledExecutorFactoryClass(String evictionScheduledExecutorFactoryClass) {
        this.evictionScheduledExecutorFactoryClass = evictionScheduledExecutorFactoryClass;
    }

    public void setReplicationQueueScheduledExecutorFactoryClass(String replicationQueueScheduledExecutorFactoryClass) {
        this.replicationQueueScheduledExecutorFactoryClass = replicationQueueScheduledExecutorFactoryClass;
    }

    public void setMarshallerClass(String marshallerClass) {
        this.marshallerClass = marshallerClass;
    }

    public void setTransportProperties(Properties transportProperties) {
        this.transportProperties = transportProperties;
    }

    public void setShutdownHookBehavior(String shutdownHookBehavior) {
        this.shutdownHookBehavior = shutdownHookBehavior;
    }

    public void setAsyncTransportExecutorProperties(Properties asyncTransportExecutorProperties) {
        this.asyncTransportExecutorProperties = asyncTransportExecutorProperties;
    }

    public void setAsyncListenerExecutorProperties(Properties asyncListenerExecutorProperties) {
        this.asyncListenerExecutorProperties = asyncListenerExecutorProperties;
    }

    public void setRemoteCommandsExecutorProperties(Properties remoteCommandsExecutorProperties) {
        this.remoteCommandsExecutorProperties = remoteCommandsExecutorProperties;
    }

    public void setEvictionScheduledExecutorProperties(Properties evictionScheduledExecutorProperties) {
        this.evictionScheduledExecutorProperties = evictionScheduledExecutorProperties;
    }

    public void setReplicationQueueScheduledExecutorProperties(Properties replicationQueueScheduledExecutorProperties) {
        this.replicationQueueScheduledExecutorProperties = replicationQueueScheduledExecutorProperties;
    }

    public void setMarshallVersion(Short marshallVersion) {
        this.marshallVersion = marshallVersion;
    }

    public void applyOverridesTo(GlobalConfigurationBuilder globalConfigurationToOverride) {
        this.logger.debug((Object)("Applying configuration overrides to GlobalConfiguration [" + globalConfigurationToOverride + "] ..."));
        if (this.exposeGlobalJmxStatistics != null) {
            this.logger.debug((Object)("Overriding property [exposeGlobalJmxStatistics] with new value [" + this.exposeGlobalJmxStatistics + "]"));
            globalConfigurationToOverride.globalJmxStatistics().enabled(this.exposeGlobalJmxStatistics.booleanValue());
        }
        if (this.mBeanServerProperties != null) {
            this.logger.debug((Object)("Overriding property [mBeanServerProperties] with new value [" + this.mBeanServerProperties + "]"));
            globalConfigurationToOverride.globalJmxStatistics().withProperties(this.mBeanServerProperties);
        }
        if (this.jmxDomain != null) {
            this.logger.debug((Object)("Overriding property [jmxDomain] with new value [" + this.jmxDomain + "]"));
            globalConfigurationToOverride.globalJmxStatistics().jmxDomain(this.jmxDomain);
        }
        if (this.mBeanServerLookupClass != null) {
            this.logger.debug((Object)("Overriding property [mBeanServerLookupClass] with new value [" + this.mBeanServerLookupClass + "]"));
            globalConfigurationToOverride.globalJmxStatistics().mBeanServerLookup((MBeanServerLookup)Util.getInstance((String)this.mBeanServerLookupClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.mBeanServerLookup != null) {
            this.logger.debug((Object)("Overriding property [mBeanServerLookup] with new value [" + this.mBeanServerLookup + "]"));
            globalConfigurationToOverride.globalJmxStatistics().mBeanServerLookup(this.mBeanServerLookup);
        }
        if (this.allowDuplicateDomains != null) {
            this.logger.debug((Object)("Overriding property [allowDuplicateDomains] with new value [" + this.allowDuplicateDomains + "]"));
            globalConfigurationToOverride.globalJmxStatistics().allowDuplicateDomains(this.allowDuplicateDomains);
        }
        if (this.cacheManagerName != null) {
            this.logger.debug((Object)("Overriding property [cacheManagerName] with new value [" + this.cacheManagerName + "]"));
            globalConfigurationToOverride.globalJmxStatistics().cacheManagerName(this.cacheManagerName);
        }
        if (this.clusterName != null) {
            this.logger.debug((Object)("Overriding property [clusterName] with new value [" + this.clusterName + "]"));
            globalConfigurationToOverride.transport().clusterName(this.clusterName);
        }
        if (this.machineId != null) {
            this.logger.debug((Object)("Overriding property [machineId] with new value [" + this.machineId + "]"));
            globalConfigurationToOverride.transport().machineId(this.machineId);
        }
        if (this.rackId != null) {
            this.logger.debug((Object)("Overriding property [rackId] with new value [" + this.rackId + "]"));
            globalConfigurationToOverride.transport().rackId(this.rackId);
        }
        if (this.siteId != null) {
            this.logger.debug((Object)("Overriding property [siteId] with new value [" + this.siteId + "]"));
            globalConfigurationToOverride.transport().siteId(this.siteId);
        }
        if (this.strictPeerToPeer != null) {
            this.logger.debug((Object)("Overriding property [strictPeerToPeer] with new value [" + this.strictPeerToPeer + "]"));
            globalConfigurationToOverride.transport().strictPeerToPeer(this.strictPeerToPeer);
        }
        if (this.distributedSyncTimeout != null) {
            this.logger.debug((Object)("Overriding property [distributedSyncTimeout] with new value [" + this.distributedSyncTimeout + "]"));
            globalConfigurationToOverride.transport().distributedSyncTimeout(this.distributedSyncTimeout.longValue());
        }
        if (this.transportClass != null) {
            this.logger.debug((Object)("Overriding property [transportClass] with new value [" + this.transportClass + "]"));
            globalConfigurationToOverride.transport().transport((Transport)Util.getInstance((String)this.transportClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.transportNodeName != null) {
            this.logger.debug((Object)("Overriding property [transportNodeName] with new value [" + this.transportNodeName + "]"));
            globalConfigurationToOverride.transport().nodeName(this.transportNodeName);
        }
        if (this.asyncListenerExecutorFactoryClass != null) {
            this.logger.debug((Object)("Overriding property [asyncListenerExecutorFactoryClass] with new value [" + this.asyncListenerExecutorFactoryClass + "]"));
            globalConfigurationToOverride.asyncListenerExecutor().factory((ExecutorFactory)Util.getInstance((String)this.asyncListenerExecutorFactoryClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.asyncTransportExecutorFactoryClass != null) {
            this.logger.debug((Object)("Overriding property [asyncTransportExecutorFactoryClass] with new value [" + this.asyncTransportExecutorFactoryClass + "]"));
            globalConfigurationToOverride.asyncTransportExecutor().factory((ExecutorFactory)Util.getInstance((String)this.asyncTransportExecutorFactoryClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.remoteCommandsExecutorFactoryClass != null) {
            this.logger.debug((Object)("Overriding property [remoteCommandsExecutorFactoryClass] with new value [" + this.remoteCommandsExecutorFactoryClass + "]"));
            globalConfigurationToOverride.remoteCommandsExecutor().factory((ExecutorFactory)Util.getInstance((String)this.remoteCommandsExecutorFactoryClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.evictionScheduledExecutorFactoryClass != null) {
            this.logger.debug((Object)("Overriding property [evictionScheduledExecutorFactoryClass] with new value [" + this.evictionScheduledExecutorFactoryClass + "]"));
            globalConfigurationToOverride.evictionScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance((String)this.evictionScheduledExecutorFactoryClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.replicationQueueScheduledExecutorFactoryClass != null) {
            this.logger.debug((Object)("Overriding property [replicationQueueScheduledExecutorFactoryClass] with new value [" + this.replicationQueueScheduledExecutorFactoryClass + "]"));
            globalConfigurationToOverride.replicationQueueScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance((String)this.replicationQueueScheduledExecutorFactoryClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.marshallerClass != null) {
            this.logger.debug((Object)("Overriding property [marshallerClass] with new value [" + this.marshallerClass + "]"));
            globalConfigurationToOverride.serialization().marshaller((Marshaller)Util.getInstance((String)this.marshallerClass, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        if (this.transportProperties != null) {
            this.logger.debug((Object)("Overriding property [transportProperties] with new value [" + this.transportProperties + "]"));
            globalConfigurationToOverride.transport().withProperties(this.transportProperties);
        }
        if (this.shutdownHookBehavior != null) {
            this.logger.debug((Object)("Overriding property [shutdownHookBehavior] with new value [" + this.shutdownHookBehavior + "]"));
            globalConfigurationToOverride.shutdown().hookBehavior(ShutdownHookBehavior.valueOf((String)this.shutdownHookBehavior));
        }
        if (this.asyncListenerExecutorProperties != null) {
            this.logger.debug((Object)("Overriding property [asyncListenerExecutorProperties] with new value [" + this.asyncListenerExecutorProperties + "]"));
            globalConfigurationToOverride.asyncListenerExecutor().withProperties(this.asyncListenerExecutorProperties);
        }
        if (this.asyncTransportExecutorProperties != null) {
            this.logger.debug((Object)("Overriding property [asyncTransportExecutorProperties] with new value [" + this.asyncTransportExecutorProperties + "]"));
            globalConfigurationToOverride.asyncTransportExecutor().withProperties(this.asyncTransportExecutorProperties);
        }
        if (this.remoteCommandsExecutorProperties != null) {
            this.logger.debug((Object)("Overriding property [remoteCommandsExecutorProperties] with new value [" + this.remoteCommandsExecutorProperties + "]"));
            globalConfigurationToOverride.remoteCommandsExecutor().withProperties(this.remoteCommandsExecutorProperties);
        }
        if (this.evictionScheduledExecutorProperties != null) {
            this.logger.debug((Object)("Overriding property [evictionScheduledExecutorProperties] with new value [" + this.evictionScheduledExecutorProperties + "]"));
            globalConfigurationToOverride.evictionScheduledExecutor().withProperties(this.evictionScheduledExecutorProperties);
        }
        if (this.replicationQueueScheduledExecutorProperties != null) {
            this.logger.debug((Object)("Overriding property [replicationQueueScheduledExecutorProperties] with new value [" + this.replicationQueueScheduledExecutorProperties + "]"));
            globalConfigurationToOverride.replicationQueueScheduledExecutor().withProperties(this.replicationQueueScheduledExecutorProperties);
        }
        if (this.marshallVersion != null) {
            this.logger.debug((Object)("Overriding property [marshallVersion] with new value [" + this.marshallVersion + "]"));
            globalConfigurationToOverride.serialization().version(this.marshallVersion.shortValue());
        }
        this.logger.debug((Object)("Finished applying configuration overrides to GlobalConfiguration [" + globalConfigurationToOverride + "]"));
    }
}

