/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.core.io.Resource;

public class AbstractEmbeddedCacheManagerFactory {
    protected static final Log logger = LogFactory.getLog(AbstractEmbeddedCacheManagerFactory.class);
    private Resource configurationFileLocation;
    private GlobalConfigurationBuilder gcb;
    private ConfigurationBuilder builder;

    protected EmbeddedCacheManager createBackingEmbeddedCacheManager() throws IOException {
        if (this.configurationFileLocation != null) {
            return this.createCacheManager(this.configurationFileLocation.getInputStream());
        }
        if (this.gcb == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"GlobalConfigurationBuilder is null. Using default new instance.");
            }
            this.gcb = new GlobalConfigurationBuilder();
        }
        if (this.builder == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ConfigurationBuilder is null. Using default new instance.");
            }
            this.builder = new ConfigurationBuilder();
        }
        EmbeddedCacheManager cm = this.createCacheManager(this.gcb, this.builder);
        return cm;
    }

    protected EmbeddedCacheManager createCacheManager(InputStream is) throws IOException {
        return new DefaultCacheManager(is);
    }

    protected EmbeddedCacheManager createCacheManager(GlobalConfigurationBuilder globalBuilder, ConfigurationBuilder builder) {
        return new DefaultCacheManager(globalBuilder.build(), builder.build());
    }

    public void setConfigurationFileLocation(Resource configurationFileLocation) {
        this.configurationFileLocation = configurationFileLocation;
    }

    public void addCustomGlobalConfiguration(GlobalConfigurationBuilder gcb) {
        this.gcb = gcb;
    }

    public void addCustomCacheConfiguration(ConfigurationBuilder builder) {
        this.builder = builder;
    }
}

