/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.remote;

import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class InfinispanNamedRemoteCacheFactoryBean<K, V>
implements FactoryBean<RemoteCache<K, V>>,
BeanNameAware,
InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private RemoteCacheManager infinispanRemoteCacheManager;
    private String cacheName;
    private String beanName;
    private RemoteCache<K, V> infinispanCache;

    public void afterPropertiesSet() throws Exception {
        if (this.infinispanRemoteCacheManager == null) {
            throw new IllegalStateException("No Infinispan RemoteCacheManager has been set");
        }
        this.logger.info((Object)"Initializing named Infinispan remote cache ...");
        String effectiveCacheName = this.obtainEffectiveCacheName();
        this.infinispanCache = this.infinispanRemoteCacheManager.getCache(effectiveCacheName);
        this.logger.info((Object)("New Infinispan remote cache [" + this.infinispanCache + "] initialized"));
    }

    private String obtainEffectiveCacheName() {
        if (StringUtils.hasText((String)this.cacheName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using custom cache name [" + this.cacheName + "]"));
            }
            return this.cacheName;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using bean name [" + this.beanName + "] as cache name"));
        }
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public RemoteCache<K, V> getObject() throws Exception {
        return this.infinispanCache;
    }

    public Class<? extends ConcurrentMap> getObjectType() {
        return this.infinispanCache != null ? this.infinispanCache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setInfinispanRemoteCacheManager(RemoteCacheManager infinispanRemoteCacheManager) {
        this.infinispanRemoteCacheManager = infinispanRemoteCacheManager;
    }
}

