/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.spring.provider.NullValue;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

class CacheDelegate
implements Cache {
    private final Map<Object, ReentrantLock> synchronousGetLocks = new ConcurrentHashMap<Object, ReentrantLock>();
    private final BasicCache<Object, Object> nativeCache;

    public CacheDelegate(BasicCache<Object, Object> nativeCache) {
        Assert.notNull(nativeCache, (String)"A non-null Infinispan cache implementation is required");
        this.nativeCache = nativeCache;
    }

    public String getName() {
        return this.nativeCache.getName();
    }

    public BasicCache<?, ?> getNativeCache() {
        return this.nativeCache;
    }

    public Cache.ValueWrapper get(Object key) {
        return this.toValueWrapper(this.nativeCache.get(key));
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.nativeCache.get(key);
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value;
        block7: {
            ReentrantLock lock = null;
            value = this.nativeCache.get(key);
            if (value == null) {
                lock = this.synchronousGetLocks.computeIfAbsent(key, k -> new ReentrantLock());
                lock.lock();
                try {
                    value = this.nativeCache.get(key);
                    if (value != null) break block7;
                    try {
                        T newValue = valueLoader.call();
                        value = this.nativeCache.putIfAbsent(key, newValue);
                        if (value == null) {
                            value = newValue;
                        }
                    }
                    catch (Exception e) {
                        throw ValueRetrievalExceptionResolver.throwValueRetrievalException(key, valueLoader, e);
                    }
                }
                finally {
                    lock.unlock();
                    this.synchronousGetLocks.remove(key);
                }
            }
        }
        return (T)value;
    }

    public void put(Object key, Object value) {
        this.nativeCache.put(key, value != null ? value : NullValue.NULL);
    }

    public void put(Object key, Object value, long lifespan, TimeUnit unit) {
        this.nativeCache.put(key, value != null ? value : NullValue.NULL, lifespan, unit);
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        return this.toValueWrapper(this.nativeCache.putIfAbsent(key, value));
    }

    public void evict(Object key) {
        this.nativeCache.remove(key);
    }

    public void clear() {
        this.nativeCache.clear();
    }

    public String toString() {
        return "InfinispanCache [nativeCache = " + this.nativeCache + "]";
    }

    private Cache.ValueWrapper toValueWrapper(Object value) {
        if (value == null) {
            return null;
        }
        if (value == NullValue.NULL) {
            return NullValue.NULL;
        }
        return new SimpleValueWrapper(value);
    }

    private static class ValueRetrievalExceptionResolver {
        private ValueRetrievalExceptionResolver() {
        }

        static RuntimeException throwValueRetrievalException(Object key, Callable<?> loader, Throwable ex) {
            return new Cache.ValueRetrievalException(key, loader, ex);
        }
    }
}

