/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.session;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractApplicationPublisherBridge;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.remote.session.RemoteApplicationPublishedBridge;

public class InfinispanRemoteSessionRepository
extends AbstractInfinispanSessionRepository {
    public InfinispanRemoteSessionRepository(SpringCache cache) {
        super(cache, (AbstractApplicationPublisherBridge)new RemoteApplicationPublishedBridge(cache));
    }

    protected void removeFromCacheWithoutNotifications(String originalId) {
        RemoteCache remoteCache = (RemoteCache)this.cache.getNativeCache();
        if (this.cache.getWriteTimeout() > 0L) {
            try {
                remoteCache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).removeAsync((Object)originalId).get(this.cache.getWriteTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException((Throwable)e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new CacheException((Throwable)e);
            }
        } else {
            remoteCache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).remove((Object)originalId);
        }
    }
}

