/**
 * <h2>Spring Infinispan - Shared classes.</h2>
 * This package contains classes that are shared between the two major themes underlying <em>Spring Infinispan</em>:
 * <ol>
 *   <li>
 *     Implement a provider for <a href="http://www.springsource.com">Spring</a> Cache abstraction backed by the open-source
 *     high-performance distributed cache <a href="http://www.jboss.org/infinispan">JBoss Infinispan</a>.<br/><br/>
 *     See package {@link org.infinispan.spring.common.provider}.<br/><br/>
 *   </li>
 *   <li>
 *     Provide implementations of Spring's {@link org.springframework.beans.factory.FactoryBean}
 *     interface for easing usage of JBoss Infinispan within the Spring programming model.<br/><br/>
 *   </li>
 *   <li>
 *     Provide implementations of Spring's Session
 *     {@link org.springframework.session.SessionRepository} interface for session
 *     management with Spring and Spring Security.
 *   </li>
 * </ol>
 */
package org.infinispan.spring.common;
