/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.testcontainers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.testcontainers.containers.GenericContainer;

public class InfinispanContainer
extends GenericContainer<InfinispanContainer> {
    private String cacheName;
    private RemoteCacheManager cacheManager;

    public InfinispanContainer() {
        this("jboss/infinispan-server");
    }

    public InfinispanContainer(String imageName) {
        super(imageName);
        this.withExposedPorts(new Integer[]{11222});
    }

    public RemoteCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public InfinispanContainer withCache(String cacheName) {
        this.cacheName = cacheName;
        return this;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        ConfigurationBuilder configBuilder = new ConfigurationBuilder().addServers(this.getContainerIpAddress() + ":" + this.getMappedPort(11222)).clientIntelligence(ClientIntelligence.BASIC);
        configBuilder.statistics().enable().statistics().jmxEnable();
        this.cacheManager = new RemoteCacheManager(configBuilder.build());
        if (this.cacheName != null) {
            this.getCacheManager().administration().createCache(this.cacheName, "default");
        }
    }

    public void stop() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
        super.stop();
    }
}

