/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.table.management.TableManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;

abstract class AbstractJdbcEntryIterator
implements Iterator<MarshallableEntry>,
AutoCloseable {
    final ConnectionFactory connectionFactory;
    final TableManager tableManager;
    final StreamingMarshaller marshaller;
    private Connection conn;
    private PreparedStatement ps;
    ResultSet rs;
    int numberOfRows = 0;
    int rowIndex = 0;

    AbstractJdbcEntryIterator(ConnectionFactory connectionFactory, TableManager tableManager, StreamingMarshaller marshaller) {
        this.connectionFactory = connectionFactory;
        this.tableManager = tableManager;
        this.marshaller = marshaller;
        PreparedStatement countPs = null;
        ResultSet countRs = null;
        try {
            this.conn = connectionFactory.getConnection();
            countPs = this.conn.prepareStatement(tableManager.getCountNonExpiredRowsSql());
            countPs.setLong(1, System.currentTimeMillis());
            countRs = countPs.executeQuery();
            countRs.next();
            this.numberOfRows = countRs.getInt(1);
            this.ps = this.conn.prepareStatement(tableManager.getLoadAllRowsSql(), 1003, 1007);
            this.ps.setFetchSize(tableManager.getFetchSize());
            this.rs = this.ps.executeQuery();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("SQL error while fetching all StoredEntries", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(countPs);
                JdbcUtil.safeClose(countRs);
                throw throwable;
            }
        }
        JdbcUtil.safeClose((Statement)countPs);
        JdbcUtil.safeClose((ResultSet)countRs);
    }

    @Override
    public void close() {
        JdbcUtil.safeClose((ResultSet)this.rs);
        JdbcUtil.safeClose((Statement)this.ps);
        this.connectionFactory.releaseConnection(this.conn);
    }
}

