/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.marshall.persistence.impl.MarshalledEntryFactoryImpl;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.marshaller.Infinispan8Marshaller;
import org.infinispan.tools.store.migrator.marshaller.MarshallerType;

public class SerializationConfigUtil {
    public static void configureSerialization(StoreProperties props, SerializationConfigurationBuilder builder) {
        StreamingMarshaller marshaller = SerializationConfigUtil.getMarshaller(props);
        builder.marshaller((Marshaller)marshaller);
        SerializationConfigUtil.configureExternalizers(props, builder);
    }

    public static MarshallableEntryFactory getEntryFactory(StoreProperties props) {
        return SerializationConfigUtil.getEntryFactory((Marshaller)SerializationConfigUtil.getMarshaller(props));
    }

    public static MarshallableEntryFactory getEntryFactory(Marshaller marshaller) {
        return new MarshalledEntryFactoryImpl(marshaller);
    }

    public static StreamingMarshaller getMarshaller(StoreProperties props) {
        if (SerializationConfigUtil.isCustomMarshaller(props)) {
            String marshallerClass = props.get(Element.MARSHALLER, Element.CLASS);
            if (marshallerClass == null) {
                throw new CacheConfigurationException(String.format("The property %s.%s must be set if a custom marshaller type is specified", new Object[]{Element.MARSHALLER, Element.CLASS}));
            }
            try {
                return (StreamingMarshaller)Util.loadClass((String)marshallerClass, (ClassLoader)SerializationConfigUtil.class.getClassLoader()).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CacheConfigurationException(String.format("Unable to load StreamingMarshaller '%s' for %s store", new Object[]{marshallerClass, Element.SOURCE}), (Throwable)e);
            }
        }
        int majorVersion = props.getMajorVersion();
        switch (majorVersion) {
            case 8: {
                if (props.isTargetStore()) {
                    throw new CacheConfigurationException(String.format("The marshaller associated with Infinispan %d can only be specified for source stores.", majorVersion));
                }
                return new Infinispan8Marshaller(SerializationConfigUtil.getExternalizersFromProps(props));
            }
            case 9: 
            case 10: {
                if (props.isTargetStore()) {
                    return null;
                }
                GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder().defaultCacheName(props.cacheName());
                SerializationConfigUtil.configureExternalizers(props, globalConfig.serialization());
                DefaultCacheManager manager = new DefaultCacheManager(globalConfig.build(), new ConfigurationBuilder().build());
                return (StreamingMarshaller)manager.getCache().getAdvancedCache().getComponentRegistry().getComponent(StreamingMarshaller.class);
            }
        }
        throw new IllegalStateException(String.format("Unexpected major version '%d'", majorVersion));
    }

    private static boolean isCustomMarshaller(StoreProperties props) {
        String marshallerTypeProp = props.get(Element.MARSHALLER, Element.TYPE);
        if (marshallerTypeProp != null) {
            return MarshallerType.valueOf(props.get(Element.MARSHALLER, Element.TYPE).toUpperCase()) == MarshallerType.CUSTOM;
        }
        return false;
    }

    private static void configureExternalizers(StoreProperties props, SerializationConfigurationBuilder builder) {
        Map<Integer, AdvancedExternalizer<?>> externalizerMap = SerializationConfigUtil.getExternalizersFromProps(props);
        if (externalizerMap == null) {
            return;
        }
        for (Map.Entry<Integer, AdvancedExternalizer<?>> entry : externalizerMap.entrySet()) {
            builder.addAdvancedExternalizer(entry.getKey().intValue(), entry.getValue());
        }
    }

    private static Map<Integer, AdvancedExternalizer<?>> getExternalizersFromProps(StoreProperties props) {
        HashMap map = new HashMap();
        String externalizers = props.get(Element.MARSHALLER, Element.EXTERNALIZERS);
        if (externalizers != null) {
            for (String ext : externalizers.split(",")) {
                String[] extArray = ext.split(":");
                String className = extArray.length > 1 ? extArray[1] : extArray[0];
                AdvancedExternalizer instance = (AdvancedExternalizer)Util.getInstance((String)className, (ClassLoader)SerializationConfigUtil.class.getClassLoader());
                int id = extArray.length > 1 ? new Integer(extArray[0]) : instance.getId();
                map.put(id, instance);
            }
        }
        return map;
    }
}

