/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.config.v6.leveldb;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.rocksdb.configuration.CompressionType;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.tools.config.v6.Parser60;
import org.infinispan.tools.config.v6.leveldb.Attribute;
import org.infinispan.tools.config.v6.leveldb.Element;

@Namespace(uri="urn:infinispan:config:store:leveldb:6.0", root="leveldbStore")
public class LevelDBStoreConfigurationParser60
implements ConfigurationParser {
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case LEVELDB_STORE: {
                this.parseLevelDBCacheStore(reader, (RocksDBStoreConfigurationBuilder)builder.persistence().addStore(RocksDBStoreConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseLevelDBCacheStore(XMLExtendedStreamReader reader, RocksDBStoreConfigurationBuilder builder) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case LOCATION: {
                    builder.location(value);
                    continue block10;
                }
                case EXPIRED_LOCATION: {
                    builder.expiredLocation(value);
                    continue block10;
                }
                case IMPLEMENTATION_TYPE: {
                    continue block10;
                }
                case CLEAR_THRESHOLD: {
                    builder.clearThreshold(Integer.valueOf(value).intValue());
                    continue block10;
                }
                case EXPIRY_QUEUE_SIZE: {
                    builder.expiryQueueSize(Integer.valueOf(value).intValue());
                }
                case BLOCK_SIZE: {
                    builder.blockSize(Integer.valueOf(value).intValue());
                    continue block10;
                }
                case CACHE_SIZE: {
                    builder.cacheSize(Long.valueOf(value).longValue());
                    continue block10;
                }
                case COMPRESSION_TYPE: {
                    builder.compressionType(CompressionType.valueOf((String)value));
                    continue block10;
                }
                default: {
                    Parser60.parseCommonStoreAttributes(reader, (StoreConfigurationBuilder)builder, attrName, value, i);
                }
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }
}

