/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.infinispan8;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Immutables;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.marshall.exts.EnumSetExternalizer;
import org.infinispan.marshall.exts.MapExternalizer;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.tools.store.migrator.marshaller.common.InternalMetadataImplExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MarshalledEntryImpl;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ArrayExternalizers;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ImmutableListCopyExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ListExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.SetExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.SingletonListExternalizer;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

class ExternalizerTable
implements ObjectTable {
    private static final Map<Integer, Integer> LEGACY_MAP;
    static int ARRAY_LIST;
    static int JDK_SETS;
    static int SINGLETON_LIST;
    static int IMMUTABLE_LIST;
    static int INTERNAL_METADATA;
    static int LIST_ARRAY;
    private static final Log log;
    private static final int MAX_ID = 255;
    private final Map<Integer, ExternalizerAdapter> readers = new HashMap<Integer, ExternalizerAdapter>();
    private final StreamingMarshaller marshaller;

    ExternalizerTable(StreamingMarshaller marshaller, Map<Integer, ? extends AdvancedExternalizer> externalizerMap) {
        this.marshaller = marshaller;
        this.loadInternalMarshallables();
        this.initForeignMarshallables(externalizerMap);
    }

    public ObjectTable.Writer getObjectWriter(Object o) {
        return null;
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        int readerIndex = input.readUnsignedByte();
        int foreignId = -1;
        if (readerIndex == 255) {
            foreignId = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            readerIndex = this.generateForeignReaderIndex(foreignId);
        } else {
            Integer legacyId = LEGACY_MAP.get(readerIndex);
            if (legacyId != null) {
                readerIndex = legacyId;
            }
        }
        ExternalizerAdapter adapter = this.readers.get(readerIndex);
        if (adapter == null) {
            if (foreignId > 0) {
                throw log.missingForeignExternalizer(foreignId);
            }
            throw log.unknownExternalizerReaderIndex(readerIndex);
        }
        return adapter.externalizer.readObject((ObjectInput)input);
    }

    private void loadInternalMarshallables() {
        this.addInternalExternalizer((AdvancedExternalizer)new ListExternalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MapExternalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new SetExternalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new EnumSetExternalizer());
        this.addInternalExternalizer(new ArrayExternalizers.ListArray());
        this.addInternalExternalizer((AdvancedExternalizer)new SingletonListExternalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new ImmutableListCopyExternalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new Immutables.ImmutableMapWrapperExternalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new ByteBufferImpl.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new NumericVersion.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new ByteBufferImpl.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new KeyValuePair.Externalizer());
        this.addInternalExternalizer(new InternalMetadataImplExternalizer(INTERNAL_METADATA));
        this.addInternalExternalizer((AdvancedExternalizer)new MarshalledEntryImpl.Externalizer((Marshaller)this.marshaller));
        this.addInternalExternalizer((AdvancedExternalizer)new ImmortalCacheEntry.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MortalCacheEntry.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new TransientCacheEntry.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new TransientMortalCacheEntry.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new ImmortalCacheValue.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MortalCacheValue.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new TransientCacheValue.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new TransientMortalCacheValue.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new SimpleClusteredVersion.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MetadataImmortalCacheEntry.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MetadataMortalCacheEntry.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MetadataTransientCacheEntry.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MetadataTransientMortalCacheEntry.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MetadataImmortalCacheValue.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MetadataMortalCacheValue.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MetadataTransientCacheValue.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new MetadataTransientMortalCacheValue.Externalizer());
        this.addInternalExternalizer((AdvancedExternalizer)new EmbeddedMetadata.Externalizer());
    }

    private void addInternalExternalizer(AdvancedExternalizer ext) {
        int id = this.checkInternalIdLimit(ext.getId(), ext);
        this.updateExtReadersWithTypes(new ExternalizerAdapter(id, ext));
    }

    private void updateExtReadersWithTypes(ExternalizerAdapter adapter) {
        this.updateExtReadersWithTypes(adapter, adapter.id);
    }

    private void updateExtReadersWithTypes(ExternalizerAdapter adapter, int readerIndex) {
        Set typeClasses = adapter.externalizer.getTypeClasses();
        if (typeClasses.size() > 0) {
            for (Class typeClass : typeClasses) {
                this.updateExtReaders(adapter, typeClass, readerIndex);
            }
        } else {
            throw log.advanceExternalizerTypeClassesUndefined(adapter.externalizer.getClass().getName());
        }
    }

    private void initForeignMarshallables(Map<Integer, ? extends AdvancedExternalizer> externalizerMap) {
        for (Map.Entry<Integer, ? extends AdvancedExternalizer> entry : externalizerMap.entrySet()) {
            AdvancedExternalizer ext = entry.getValue();
            Integer id = ext.getId();
            if (entry.getKey() == null && id == null) {
                throw new CacheConfigurationException(String.format("No advanced externalizer identifier set for externalizer %s", ext.getClass().getName()));
            }
            if (entry.getKey() != null) {
                id = entry.getKey();
            }
            id = this.checkForeignIdLimit(id, ext);
            this.updateExtReadersWithTypes(new ExternalizerAdapter(id, ext), this.generateForeignReaderIndex(id));
        }
    }

    private void updateExtReaders(ExternalizerAdapter adapter, Class<?> typeClass, int readerIndex) {
        ExternalizerAdapter prevReader = this.readers.put(readerIndex, adapter);
        if (prevReader != null && !prevReader.equals(adapter)) {
            throw log.duplicateExternalizerIdFound(adapter.id, typeClass, prevReader.externalizer.getClass().getName(), readerIndex);
        }
    }

    private int checkInternalIdLimit(int id, AdvancedExternalizer ext) {
        if (id >= 255) {
            throw log.internalExternalizerIdLimitExceeded(ext, id, 255);
        }
        return id;
    }

    private int checkForeignIdLimit(int id, AdvancedExternalizer ext) {
        if (id < 0) {
            throw log.foreignExternalizerUsingNegativeId(ext, id);
        }
        return id;
    }

    private int generateForeignReaderIndex(int foreignId) {
        return Integer.MIN_VALUE | foreignId;
    }

    static {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(2, 1);
        map.put(10, 7);
        map.put(11, 8);
        map.put(12, 9);
        map.put(13, 10);
        map.put(14, 11);
        map.put(15, 12);
        map.put(16, 13);
        map.put(17, 14);
        map.put(19, 105);
        map.put(76, 38);
        map.put(77, 39);
        map.put(78, 40);
        map.put(79, 41);
        map.put(80, 42);
        map.put(81, 43);
        map.put(82, 44);
        map.put(83, 45);
        map.put(96, 55);
        map.put(98, 57);
        map.put(99, 58);
        map.put(103, 60);
        map.put(105, 62);
        map.put(106, 106);
        map.put(121, 63);
        LEGACY_MAP = Collections.unmodifiableMap(map);
        ARRAY_LIST = 0;
        JDK_SETS = 3;
        SINGLETON_LIST = 4;
        IMMUTABLE_LIST = 18;
        INTERNAL_METADATA = 104;
        LIST_ARRAY = 122;
        log = LogFactory.getLog(ExternalizerTable.class);
    }

    private static class ExternalizerAdapter {
        final int id;
        final AdvancedExternalizer externalizer;

        ExternalizerAdapter(int id, AdvancedExternalizer externalizer) {
            this.id = id;
            this.externalizer = externalizer;
        }

        public String toString() {
            return this.externalizer.getClass().getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalizerAdapter that = (ExternalizerAdapter)o;
            if (this.id != that.id) {
                return false;
            }
            return !(this.externalizer != null ? !this.externalizer.getClass().equals(that.externalizer.getClass()) : that.externalizer != null);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.externalizer.getClass() != null ? this.externalizer.getClass().hashCode() : 0);
            return result;
        }
    }
}

