/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.entries.MortalCacheValue;

public class MortalCacheValueExternalizer
implements AdvancedExternalizer<MortalCacheValue> {
    public Set<Class<? extends MortalCacheValue>> getTypeClasses() {
        return Collections.singleton(MortalCacheValue.class);
    }

    public Integer getId() {
        return 12;
    }

    public void writeObject(ObjectOutput output, MortalCacheValue icv) throws IOException {
        output.writeObject(icv.getValue());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)icv.getCreated());
        output.writeLong(icv.getLifespan());
    }

    public MortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object value = input.readObject();
        long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        long lifespan = input.readLong();
        return new MortalCacheValue(value, created, lifespan);
    }
}

