/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.persistence.jdbc.common.JdbcUtil;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;

abstract class AbstractJdbcEntryIterator
implements Iterator<MarshallableEntry>,
AutoCloseable {
    final ConnectionFactory connectionFactory;
    final TableManager tableManager;
    final Marshaller marshaller;
    private Connection conn;
    private PreparedStatement ps;
    ResultSet rs;
    long numberOfRows = 0L;
    int rowIndex = 0;

    AbstractJdbcEntryIterator(ConnectionFactory connectionFactory, TableManager tableManager, Marshaller marshaller) {
        this.connectionFactory = connectionFactory;
        this.tableManager = tableManager;
        this.marshaller = marshaller;
        try {
            this.conn = connectionFactory.getConnection();
            this.numberOfRows = tableManager.size(this.conn);
            this.ps = this.conn.prepareStatement(tableManager.getLoadAllRowsSql(), 1003, 1007);
            this.ps.setFetchSize(tableManager.getFetchSize());
            this.rs = this.ps.executeQuery();
        }
        catch (SQLException e) {
            throw new PersistenceException("SQL error while fetching all StoredEntries", (Throwable)e);
        }
    }

    @Override
    public void close() {
        JdbcUtil.safeClose((ResultSet)this.rs);
        JdbcUtil.safeClose((Statement)this.ps);
        this.connectionFactory.releaseConnection(this.conn);
    }
}

