/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.marshall.core.Ids;
import org.infinispan.metadata.Metadata;

public class MetadataTransientMortalCacheEntryExternalizer
implements AdvancedExternalizer<MetadataTransientMortalCacheEntry> {
    public Set<Class<? extends MetadataTransientMortalCacheEntry>> getTypeClasses() {
        return Collections.singleton(MetadataTransientMortalCacheEntry.class);
    }

    public Integer getId() {
        return Ids.METADATA_TRANSIENT_MORTAL_ENTRY;
    }

    public void writeObject(ObjectOutput output, MetadataTransientMortalCacheEntry ice) throws IOException {
        output.writeObject(ice.getKey());
        output.writeObject(ice.getValue());
        output.writeObject(ice.getMetadata());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)ice.getCreated());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)ice.getLastUsed());
    }

    public MetadataTransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object key = input.readObject();
        Object value = input.readObject();
        Metadata metadata = (Metadata)input.readObject();
        long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        return new MetadataTransientMortalCacheEntry(key, value, metadata, lastUsed, created);
    }
}

