/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryFactoryImpl;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.marshaller.infinispan10.Infinispan10Marshaller;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.Infinispan8Marshaller;
import org.infinispan.tools.store.migrator.marshaller.infinispan9.Infinispan9Marshaller;

public class SerializationConfigUtil {
    public static void configureSerialization(StoreProperties props, SerializationConfigurationBuilder builder) {
        Marshaller marshaller = SerializationConfigUtil.getMarshaller(props);
        builder.marshaller(marshaller);
        SerializationConfigUtil.configureExternalizers(props, builder);
        SerializationConfigUtil.configureSerializationContextInitializers(props, builder);
    }

    public static MarshallableEntryFactory getEntryFactory(StoreProperties props) {
        return SerializationConfigUtil.getEntryFactory(SerializationConfigUtil.getMarshaller(props));
    }

    public static MarshallableEntryFactory getEntryFactory(Marshaller marshaller) {
        return new MarshalledEntryFactoryImpl(marshaller);
    }

    public static Marshaller getMarshaller(StoreProperties props) {
        int majorVersion = props.getMajorVersion();
        if (props.isTargetStore() && majorVersion != Integer.parseInt(Version.getMajor())) {
            throw new CacheConfigurationException(String.format("The marshaller associated with Infinispan %d can only be specified for source stores.", majorVersion));
        }
        if (majorVersion < 8 || majorVersion > Integer.parseInt(Version.getMajor())) {
            throw new IllegalStateException(String.format("Unexpected major version '%d'", majorVersion));
        }
        switch (majorVersion) {
            case 8: 
            case 9: {
                Marshaller marshaller = SerializationConfigUtil.loadMarshallerInstance(props);
                if (marshaller != null) {
                    return marshaller;
                }
                Map<Integer, AdvancedExternalizer> userExts = SerializationConfigUtil.getExternalizersFromProps(props);
                return majorVersion == 8 ? new Infinispan8Marshaller(userExts) : new Infinispan9Marshaller(userExts);
            }
            case 10: 
            case 11: {
                Marshaller marshaller = SerializationConfigUtil.loadMarshallerInstance(props);
                return new Infinispan10Marshaller(marshaller, SerializationConfigUtil.getSCIClasses(props));
            }
        }
        return props.isTargetStore() ? null : SerializationConfigUtil.createPersistenceMarshaller(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistenceMarshaller createPersistenceMarshaller(StoreProperties props) {
        GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder();
        SerializationConfigUtil.configureSerializationContextInitializers(props, globalConfig.serialization());
        Marshaller marshaller = SerializationConfigUtil.loadMarshallerInstance(props);
        if (marshaller != null) {
            globalConfig.serialization().marshaller(marshaller);
        }
        DefaultCacheManager manager = new DefaultCacheManager(globalConfig.build());
        try {
            Cache cache = manager.createCache(props.cacheName(), new ConfigurationBuilder().build());
            PersistenceMarshaller persistenceMarshaller = (PersistenceMarshaller)cache.getAdvancedCache().getComponentRegistry().getComponent(PersistenceMarshaller.class, "org.infinispan.marshaller.persistence");
            return persistenceMarshaller;
        }
        finally {
            manager.stop();
        }
    }

    private static Marshaller loadMarshallerInstance(StoreProperties props) {
        String marshallerClass = props.get(Element.MARSHALLER, Element.CLASS);
        if (marshallerClass != null) {
            try {
                return (Marshaller)Util.loadClass((String)marshallerClass, (ClassLoader)SerializationConfigUtil.class.getClassLoader()).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CacheConfigurationException(String.format("Unable to load StreamingMarshaller '%s' for %s store", new Object[]{marshallerClass, Element.SOURCE}), (Throwable)e);
            }
        }
        return null;
    }

    private static void configureExternalizers(StoreProperties props, SerializationConfigurationBuilder builder) {
        Map<Integer, AdvancedExternalizer> externalizerMap = SerializationConfigUtil.getExternalizersFromProps(props);
        if (externalizerMap == null) {
            return;
        }
        for (Map.Entry<Integer, AdvancedExternalizer> entry : externalizerMap.entrySet()) {
            builder.addAdvancedExternalizer(entry.getKey().intValue(), entry.getValue());
        }
    }

    private static Map<Integer, AdvancedExternalizer> getExternalizersFromProps(StoreProperties props) {
        HashMap<Integer, AdvancedExternalizer> map = new HashMap<Integer, AdvancedExternalizer>();
        String externalizers = props.get(Element.MARSHALLER, Element.EXTERNALIZERS);
        if (externalizers != null) {
            for (String ext : externalizers.split(",")) {
                String[] extArray = ext.split(":");
                String className = extArray.length > 1 ? extArray[1] : extArray[0];
                AdvancedExternalizer instance = (AdvancedExternalizer)Util.getInstance((String)className, (ClassLoader)SerializationConfigUtil.class.getClassLoader());
                int id = extArray.length > 1 ? new Integer(extArray[0]) : instance.getId();
                map.put(id, instance);
            }
        }
        return map;
    }

    private static void configureSerializationContextInitializers(StoreProperties props, SerializationConfigurationBuilder builder) {
        SerializationConfigUtil.getSCIClasses(props).forEach(arg_0 -> ((SerializationConfigurationBuilder)builder).addContextInitializer(arg_0));
    }

    public static List<SerializationContextInitializer> getSCIClasses(StoreProperties props) {
        String sciString = props.get(Element.MARSHALLER, Element.CONTEXT_INITIALIZERS);
        if (sciString == null) {
            return new ArrayList<SerializationContextInitializer>();
        }
        return Arrays.stream(sciString.split(",")).map(impl -> (SerializationContextInitializer)Util.getInstance((String)impl, (ClassLoader)SerializationConfigUtil.class.getClassLoader())).collect(Collectors.toList());
    }
}

