/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.StoreType;

public class JdbcConfigurationUtil {
    static JdbcStringBasedStoreConfiguration getStoreConfig(StoreProperties props) {
        JdbcStringBasedStoreConfigurationBuilder builder = (JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        JdbcConfigurationUtil.configureStore(props, builder);
        return builder.create();
    }

    public static JdbcStringBasedStoreConfigurationBuilder configureStore(StoreProperties props, JdbcStringBasedStoreConfigurationBuilder builder) {
        StoreType type = props.storeType();
        JdbcConfigurationUtil.configureDbMeta(props, builder);
        if (type == StoreType.JDBC_MIXED || type == StoreType.JDBC_STRING) {
            JdbcConfigurationUtil.createTableConfig(props, Element.STRING, builder);
            String mapper = props.get(Element.KEY_TO_STRING_MAPPER);
            if (mapper != null) {
                builder.key2StringMapper(props.get(Element.KEY_TO_STRING_MAPPER));
            }
        }
        if (type == StoreType.JDBC_MIXED || type == StoreType.JDBC_BINARY) {
            JdbcConfigurationUtil.createTableConfig(props, Element.BINARY, builder);
        }
        JdbcConfigurationUtil.createConnectionConfig(props, builder);
        builder.validate();
        return builder;
    }

    static TableManipulationConfiguration createTableConfig(StoreProperties props, Element tableType, JdbcStringBasedStoreConfigurationBuilder storeBuilder) {
        return ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)storeBuilder.table().createOnStart(props.isTargetStore())).tableNamePrefix(props.get(Element.TABLE, tableType, Element.TABLE_NAME_PREFIX))).idColumnName(props.get(Element.TABLE, tableType, Element.ID, Element.NAME))).idColumnType(props.get(Element.TABLE, tableType, Element.ID, Element.TYPE))).dataColumnName(props.get(Element.TABLE, tableType, Element.DATA, Element.NAME))).dataColumnType(props.get(Element.TABLE, tableType, Element.DATA, Element.TYPE))).timestampColumnName(props.get(Element.TABLE, tableType, Element.TIMESTAMP, Element.NAME))).timestampColumnType(props.get(Element.TABLE, tableType, Element.TIMESTAMP, Element.TYPE))).segmentColumnName(props.get(Element.TABLE, tableType, Element.SEGMENT, Element.NAME))).segmentColumnType(props.get(Element.TABLE, tableType, Element.SEGMENT, Element.TYPE))).create();
    }

    private static void configureDbMeta(StoreProperties props, JdbcStringBasedStoreConfigurationBuilder builder) {
        String disableIndexing;
        boolean indexing;
        String disableUpsert;
        boolean upsert;
        props.required(Element.DIALECT);
        DatabaseType type = DatabaseType.valueOf((String)props.get(Element.DIALECT).toUpperCase());
        builder.dialect(type);
        String prop = props.get(Element.DB, Element.MAJOR_VERSION);
        if (prop != null) {
            builder.dbMajorVersion(Integer.valueOf(Integer.parseInt(prop)));
        }
        if ((prop = props.get(Element.DB, Element.MINOR_VERSION)) != null) {
            builder.dbMinorVersion(Integer.valueOf(Integer.parseInt(prop)));
        }
        if (upsert = Boolean.parseBoolean(disableUpsert = props.get(Element.DB, Element.DISABLE_UPSERT))) {
            builder.addProperty("infinispan.jdbc.upsert.disabled", disableUpsert);
        }
        if (indexing = Boolean.parseBoolean(disableIndexing = props.get(Element.DB, Element.DISABLE_INDEXING))) {
            builder.addProperty("infinispan.jdbc.indexing.disabled", disableIndexing);
        }
    }

    private static void createConnectionConfig(StoreProperties props, JdbcStringBasedStoreConfigurationBuilder storeBuilder) {
        props.required(props.key(Element.CONNECTION_POOL, Element.CONNECTION_URL));
        props.required(props.key(Element.CONNECTION_POOL, Element.DRIVER_CLASS));
        storeBuilder.connectionPool().connectionUrl(props.get(Element.CONNECTION_POOL, Element.CONNECTION_URL)).driverClass(props.get(Element.CONNECTION_POOL, Element.DRIVER_CLASS)).username(props.get(Element.CONNECTION_POOL, Element.USERNAME)).password(props.get(Element.CONNECTION_POOL, Element.PASSWORD)).create();
    }
}

