/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.doclet.config;

import java.util.Iterator;
import org.infinispan.tools.schema.AbstractTreeWalker;
import org.infinispan.tools.schema.TreeNode;

public class XMLTreeOutputWalker
extends AbstractTreeWalker {
    private final StringBuilder sb;

    public XMLTreeOutputWalker(StringBuilder sb) {
        this.sb = sb;
    }

    @Override
    public void visitNode(TreeNode treeNode) {
        String ident = "";
        for (int i = 0; i <= treeNode.getDepth(); ++i) {
            ident = ident + "  ";
        }
        String parentName = treeNode.getParent().getName();
        if (parentName.startsWith("namedCache")) {
            parentName = "default";
        }
        this.sb.append(ident + "&lt;<a href=\"" + "#ce_" + parentName + "_" + treeNode.getName() + "\">" + treeNode.getName() + "</a>&gt;" + "\n");
    }

    public TreeNode findNode(TreeNode tn, String name, String parent) {
        TreeNode result = null;
        if (tn.getName().equals(name) && tn.getParent() != null && tn.getParent().getName().equals(parent)) {
            result = tn;
        } else {
            TreeNode child;
            Iterator<TreeNode> i$ = tn.getChildren().iterator();
            while (i$.hasNext() && (result = this.findNode(child = i$.next(), name, parent)) == null) {
            }
        }
        return result;
    }
}

