/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.doclet.config;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.tools.doclet.config.AbstractConfigHtmlGenerator;
import org.infinispan.tools.doclet.config.XMLTreeOutputWalker;
import org.infinispan.tools.schema.AbstractTreeWalker;
import org.infinispan.tools.schema.TreeNode;
import org.infinispan.tools.schema.XSOMSchemaTreeWalker;
import org.infinispan.util.ClassFinder;
import org.infinispan.util.TypedProperties;

public class ConfigHtmlGenerator
extends AbstractConfigHtmlGenerator {
    String classpath;

    public ConfigHtmlGenerator(String encoding, String title, String bottom, String footer, String header, String metaDescription, List<String> metaKeywords, String classpath) {
        super(encoding, title, bottom, footer, header, metaDescription, metaKeywords);
        this.classpath = classpath;
    }

    @Override
    protected List<Class<?>> getConfigBeans() throws Exception {
        List list = ClassFinder.isAssignableFrom((List)ClassFinder.infinispanClasses((String)this.classpath), AbstractConfigurationBean.class);
        list.add(TypedProperties.class);
        list.add(InfinispanConfiguration.class);
        return list;
    }

    @Override
    protected String getSchemaFile() {
        return String.format("schema/infinispan-config-%s.xsd", "5.1");
    }

    @Override
    protected String getTitle() {
        return String.format("<h2>Infinispan configuration options %s</h2><br/>", "5.1");
    }

    @Override
    protected String getRootElementName() {
        return "infinispan";
    }

    @Override
    protected void preXMLTableOfContentsCreate(XSOMSchemaTreeWalker sw, XMLTreeOutputWalker tw) {
        TreeNode root = sw.getRoot();
        TreeNode node = tw.findNode(root, "namedCache", "infinispan");
        node.detach();
        PruneTreeWalker ptw = new PruneTreeWalker("property");
        ptw.postOrderTraverse(root);
    }

    @Override
    protected boolean preVisitNode(TreeNode n) {
        return n.getName().equals("properties");
    }

    @Override
    protected boolean postVisitNode(TreeNode n) {
        if (n.hasChild("properties")) {
            this.generatePropertiesTableRows(this.getStringBuilder(), n);
        }
        return super.postVisitNode(n);
    }

    private void generatePropertiesTableRows(StringBuilder sb, TreeNode n) {
        Map<String, String> description;
        Field field = this.findField(n.getBeanClass(), "properties");
        if (field != null && !(description = this.findDescription(field)).isEmpty()) {
            sb.append("<table class=\"bodyTable\"> ");
            sb.append("<tr class=\"a\"><th>Property</th><th>Description</th></tr>\n");
            for (Map.Entry<String, String> e : description.entrySet()) {
                sb.append("<tr class=\"b\">");
                sb.append("<td>").append(e.getKey()).append("</td>\n");
                sb.append("<td>").append(e.getValue()).append("</td>\n");
                sb.append("</tr>\n");
            }
            sb.append("</table>\n");
        }
    }

    private static class PruneTreeWalker
    extends AbstractTreeWalker {
        private String pruneNodeName = "";

        private PruneTreeWalker(String pruneNodeName) {
            this.pruneNodeName = pruneNodeName;
        }

        @Override
        public void visitNode(TreeNode treeNode) {
            if (treeNode.getName().equals(this.pruneNodeName)) {
                treeNode.detach();
            }
        }
    }
}

