/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.rhq;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.RootDoc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.util.ClassFinder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;
import org.rhq.helpers.pluginGen.PluginGen;
import org.rhq.helpers.pluginGen.Props;
import org.rhq.helpers.pluginGen.ResourceCategory;

public class RhqPluginXmlGenerator {
    private static final Log log = LogFactory.getLog(RhqPluginXmlGenerator.class);
    private static ClassPool classPool;
    private static String cp;

    public static void main(String[] args) throws Exception {
        cp = System.getProperty("java.class.path");
        RhqPluginXmlGenerator.start(null);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        for (String[] option : options) {
            if (!option[0].equals("-classpath")) continue;
            cp = option[1];
        }
        return true;
    }

    public static boolean start(RootDoc rootDoc) throws Exception {
        List<Class<?>> mbeanIspnClasses = RhqPluginXmlGenerator.getMBeanClasses();
        ArrayList globalClasses = new ArrayList();
        ArrayList namedCacheClasses = new ArrayList();
        for (Class<?> clazz : mbeanIspnClasses) {
            Scope scope = clazz.getAnnotation(Scope.class);
            if (scope != null && scope.value() == Scopes.GLOBAL) {
                RhqPluginXmlGenerator.debug("Add as global class " + clazz);
                globalClasses.add(clazz);
                continue;
            }
            RhqPluginXmlGenerator.debug("Add as named cache class " + clazz);
            namedCacheClasses.add(clazz);
        }
        classPool = ClassPool.getDefault();
        classPool.insertClassPath((ClassPath)new ClassClassPath(RhqPluginXmlGenerator.class));
        PluginGen pg = new PluginGen();
        Props root = new Props();
        root.setPluginName("Infinispan");
        root.setPluginDescription("Supports management and monitoring of Infinispan");
        root.setManualAddOfResourceType(true);
        root.setName("Infinispan Cache Manager");
        root.setPkg("org.infinispan.rhq");
        root.setDependsOnJmxPlugin(true);
        root.setDiscoveryClass("CacheManagerDiscovery");
        root.setComponentClass("CacheManagerComponent");
        root.setSingleton(false);
        root.setCategory(ResourceCategory.SERVICE);
        HashSet<Props.TypeKey> servers = new HashSet<Props.TypeKey>();
        servers.add(new Props.TypeKey("JMX Server", "JMX"));
        servers.add(new Props.TypeKey("JBossAS Server", "JBossAS"));
        servers.add(new Props.TypeKey("JBossAS Server", "JBossAS5"));
        root.setRunsInsides(servers);
        Props.SimpleProperty pc = new Props.SimpleProperty("name");
        pc.setType("string");
        pc.setDescription("Name");
        pc.setDefaultValue("Infinispan Cache Manager");
        pc.setReadOnly(true);
        root.getSimpleProps().add(pc);
        RhqPluginXmlGenerator.populateMetricsAndOperations(globalClasses, root, false);
        Props cache = new Props();
        cache.setName("Infinispan Cache");
        cache.setPkg("org.infinispan.rhq");
        cache.setDependsOnJmxPlugin(true);
        cache.setDiscoveryClass("CacheDiscovery");
        cache.setComponentClass("CacheComponent");
        cache.setSingleton(false);
        cache.setCategory(ResourceCategory.SERVICE);
        RhqPluginXmlGenerator.populateMetricsAndOperations(namedCacheClasses, cache, true);
        root.getChildren().add(cache);
        String metaInfDir = "../../../src/main/resources/META-INF";
        new File(metaInfDir).mkdirs();
        String targetMetaInfDir = "../../../target/classes/META-INF";
        new File(targetMetaInfDir).mkdirs();
        pg.createFile(root, "ispnDescriptor", "rhq-plugin.xml", metaInfDir);
        RhqPluginXmlGenerator.copyFile(new File(metaInfDir + "/rhq-plugin.xml"), new File(targetMetaInfDir + "/rhq-plugin.xml"));
        return true;
    }

    private static void copyFile(File in, File out) throws IOException {
        FileChannel inCh = new FileInputStream(in).getChannel();
        FileChannel outCh = new FileOutputStream(out).getChannel();
        try {
            inCh.transferTo(0L, inCh.size(), outCh);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inCh != null) {
                inCh.close();
            }
            if (outCh != null) {
                outCh.close();
            }
        }
    }

    private static List<Class<?>> getMBeanClasses() throws IOException {
        try {
            return ClassFinder.withAnnotationDeclared((List)ClassFinder.infinispanClasses((String)cp), MBean.class);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to get Infinispan classes");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static void populateMetricsAndOperations(List<Class<?>> classes, Props props, boolean withNamePrefix) throws Exception {
        props.setHasOperations(true);
        props.setHasMetrics(true);
        HashSet<String> uniqueOperations = new HashSet<String>();
        for (Class<?> clazz : classes) {
            CtField[] ctFields;
            CtMethod[] ctMethods;
            MBean mbean = clazz.getAnnotation(MBean.class);
            String prefix = withNamePrefix ? mbean.objectName() + '.' : "";
            CtClass ctClass = classPool.get(clazz.getName());
            for (CtMethod ctMethod : ctMethods = ctClass.getMethods()) {
                Operation rhqOperation;
                ManagedAttribute managedAttr = (ManagedAttribute)ctMethod.getAnnotation(ManagedAttribute.class);
                ManagedOperation managedOp = (ManagedOperation)ctMethod.getAnnotation(ManagedOperation.class);
                Metric rhqMetric = (Metric)ctMethod.getAnnotation(Metric.class);
                if (rhqMetric != null) {
                    RhqPluginXmlGenerator.debug("Metric annotation found " + rhqMetric);
                    String property = prefix + RhqPluginXmlGenerator.getPropertyFromBeanConvention(ctMethod);
                    if (!rhqMetric.property().isEmpty()) {
                        property = prefix + rhqMetric.property();
                    }
                    Props.MetricProps metric = new Props.MetricProps(property);
                    String displayName = withNamePrefix ? "[" + mbean.objectName() + "] " + rhqMetric.displayName() : rhqMetric.displayName();
                    RhqPluginXmlGenerator.validateDisplayName(displayName);
                    metric.setDisplayName(displayName);
                    metric.setDisplayType(rhqMetric.displayType());
                    metric.setDataType(rhqMetric.dataType());
                    metric.setUnits(rhqMetric.units());
                    if (managedAttr != null) {
                        RhqPluginXmlGenerator.debug("Metric has ManagedAttribute annotation " + managedAttr);
                        metric.setDescription(managedAttr.description());
                    } else if (managedOp != null) {
                        RhqPluginXmlGenerator.debug("Metric has ManagedOperation annotation " + managedOp);
                        metric.setDescription(managedOp.description());
                    } else {
                        log.debug((Object)"Metric has no managed annotations, so take the description from the display name.");
                        metric.setDescription(rhqMetric.displayName());
                    }
                    props.getMetrics().add(metric);
                }
                if ((rhqOperation = (Operation)ctMethod.getAnnotation(Operation.class)) == null) continue;
                RhqPluginXmlGenerator.debug("Operation annotation found " + rhqOperation);
                String name = !rhqOperation.name().isEmpty() ? prefix + rhqOperation.name() : prefix + ctMethod.getName();
                if (uniqueOperations.contains(name)) {
                    throw new RuntimeException("Duplicate operation name: " + name);
                }
                uniqueOperations.add(name);
                Props.OperationProps operation = new Props.OperationProps(name);
                String displayName = withNamePrefix ? "[" + mbean.objectName() + "] " + rhqOperation.displayName() : rhqOperation.displayName();
                RhqPluginXmlGenerator.validateDisplayName(displayName);
                operation.setDisplayName(displayName);
                if (managedAttr != null) {
                    RhqPluginXmlGenerator.debug("Operation has ManagedAttribute annotation " + managedAttr);
                    operation.setDescription(managedAttr.description());
                } else if (managedOp != null) {
                    RhqPluginXmlGenerator.debug("Operation has ManagedOperation annotation " + managedOp);
                    operation.setDescription(managedOp.description());
                } else {
                    RhqPluginXmlGenerator.debug("Operation has no managed annotations, so take the description from the display name.");
                    operation.setDescription(rhqOperation.displayName());
                }
                Object[][] paramAnnotations = ctMethod.getParameterAnnotations();
                int i = 0;
                for (Object[] paramAnnotationsInEach : paramAnnotations) {
                    boolean hadParameter = false;
                    for (Object annot : paramAnnotationsInEach) {
                        RhqPluginXmlGenerator.debug("Parameter annotation " + annot);
                        if (!(annot instanceof Parameter)) continue;
                        Parameter param = (Parameter)annot;
                        Props.SimpleProperty prop = new Props.SimpleProperty(param.name());
                        prop.setDescription(param.description());
                        operation.getParams().add(prop);
                        hadParameter = true;
                    }
                    if (hadParameter) continue;
                    operation.getParams().add(new Props.SimpleProperty("p" + i++));
                }
                CtClass returnType = ctMethod.getReturnType();
                if (!returnType.equals(CtClass.voidType) && !returnType.equals(Void.TYPE)) {
                    Props.SimpleProperty prop = new Props.SimpleProperty("operationResult");
                    operation.setResult(prop);
                }
                props.getOperations().add(operation);
            }
            for (CtField ctField : ctFields = ctClass.getDeclaredFields()) {
                RhqPluginXmlGenerator.debug("Inspecting field " + ctField);
                Metric rhqMetric = (Metric)ctField.getAnnotation(Metric.class);
                if (rhqMetric == null) continue;
                RhqPluginXmlGenerator.debug("Field " + ctField + " contains Metric annotation " + rhqMetric);
                String property = !rhqMetric.property().isEmpty() ? prefix + rhqMetric.property() : prefix + RhqPluginXmlGenerator.getPropertyFromBeanConvention(ctField);
                Props.MetricProps metric = new Props.MetricProps(property);
                String displayName = withNamePrefix ? "[" + mbean.objectName() + "] " + rhqMetric.displayName() : rhqMetric.displayName();
                RhqPluginXmlGenerator.validateDisplayName(displayName);
                metric.setDisplayName(displayName);
                metric.setDisplayType(rhqMetric.displayType());
                metric.setDataType(rhqMetric.dataType());
                metric.setUnits(rhqMetric.units());
                ManagedAttribute managedAttr = (ManagedAttribute)ctField.getAnnotation(ManagedAttribute.class);
                if (managedAttr != null) {
                    RhqPluginXmlGenerator.debug("Metric has ManagedAttribute annotation " + managedAttr);
                    metric.setDescription(managedAttr.description());
                } else {
                    log.debug((Object)"Metric has no managed annotations, so take the description from the display name.");
                    metric.setDescription(rhqMetric.displayName());
                }
                props.getMetrics().add(metric);
            }
        }
    }

    private static void validateDisplayName(String displayName) {
        if (displayName.length() > 100) {
            throw new RuntimeException("Display name too long (max 100 chars): " + displayName);
        }
    }

    private static String getPropertyFromBeanConvention(CtMethod ctMethod) {
        String getterOrSetter = ctMethod.getName();
        if (getterOrSetter.startsWith("get") || getterOrSetter.startsWith("set")) {
            String withoutGet = getterOrSetter.substring(4);
            return Character.toUpperCase(getterOrSetter.charAt(3)) + withoutGet;
        }
        if (getterOrSetter.startsWith("is")) {
            String withoutIs = getterOrSetter.substring(3);
            return Character.toUpperCase(getterOrSetter.charAt(2)) + withoutIs;
        }
        return getterOrSetter;
    }

    private static String getPropertyFromBeanConvention(CtField ctField) {
        String fieldName = ctField.getName();
        String withoutFirstChar = fieldName.substring(1);
        return Character.toUpperCase(fieldName.charAt(0)) + withoutFirstChar;
    }

    private static void debug(Object o) {
        System.out.println(o);
    }
}

