/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.jdbc.migrator;

import java.io.FileReader;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.tools.jdbc.migrator.Element;
import org.infinispan.tools.jdbc.migrator.JdbcStoreReader;
import org.infinispan.tools.jdbc.migrator.MigratorConfiguration;

public class JDBCMigrator {
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private final String defaultCacheName = this.getClass().getName();
    private final Properties properties;

    private JDBCMigrator(Properties properties) {
        this.properties = properties;
    }

    private void run() throws Exception {
        String batchSizeProp = this.properties.getProperty((Object)((Object)Element.BATCH) + "." + (Object)((Object)Element.SIZE));
        int batchLimit = batchSizeProp != null ? new Integer(batchSizeProp) : 1000;
        try (JdbcStoreReader sourceReader = this.initAndGetSourceReader();){
            AdvancedCache targetCache = this.initAndGetTargetCache();
            TransactionManager tm = targetCache.getTransactionManager();
            int txBatchSize = 0;
            for (MarshalledEntry entry : sourceReader) {
                if (txBatchSize == 0) {
                    tm.begin();
                }
                targetCache.put(entry.getKey(), entry.getValue());
                if (++txBatchSize != batchLimit) continue;
                txBatchSize = 0;
                tm.commit();
            }
            if (tm.getStatus() == 0) {
                tm.commit();
            }
        }
    }

    private JdbcStoreReader initAndGetSourceReader() {
        MigratorConfiguration config = new MigratorConfiguration(true, this.properties);
        return new JdbcStoreReader(config);
    }

    private AdvancedCache initAndGetTargetCache() {
        MigratorConfiguration config = new MigratorConfiguration(false, this.properties);
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().defaultCacheName(this.defaultCacheName).globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true)).build();
        if (config.hasCustomMarshaller()) {
            globalConfig = new GlobalConfigurationBuilder().globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true)).serialization().marshaller((Marshaller)config.getMarshaller()).build();
        }
        Configuration cacheConfig = new ConfigurationBuilder().persistence().addStore((StoreConfigurationBuilder)config.getJdbcConfigBuilder()).build();
        DefaultCacheManager targetCacheManager = new DefaultCacheManager(globalConfig, new ConfigurationBuilder().build());
        targetCacheManager.defineConfiguration(config.cacheName, cacheConfig);
        return targetCacheManager.getCache(config.cacheName).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD});
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: JDBCMigrator migrator.properties");
            System.exit(1);
        }
        Properties properties = new Properties();
        properties.load(new FileReader(args[0]));
        new JDBCMigrator(properties).run();
    }
}

