/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.jdbc.migrator;

import java.util.Iterator;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.persistence.jdbc.table.management.TableManager;
import org.infinispan.persistence.jdbc.table.management.TableManagerFactory;
import org.infinispan.tools.jdbc.migrator.BinaryJdbcIterator;
import org.infinispan.tools.jdbc.migrator.MigratorConfiguration;
import org.infinispan.tools.jdbc.migrator.MixedJdbcIterator;
import org.infinispan.tools.jdbc.migrator.StringJdbcIterator;

class JdbcStoreReader
implements Iterable<MarshalledEntry>,
AutoCloseable {
    private final MigratorConfiguration config;
    private final StreamingMarshaller marshaller;
    private final ConnectionFactory connectionFactory;

    JdbcStoreReader(MigratorConfiguration config) {
        this.config = config;
        this.marshaller = config.getMarshaller();
        PooledConnectionFactory connectionFactory = new PooledConnectionFactory();
        connectionFactory.start(config.getConnectionConfig(), JdbcStoreReader.class.getClassLoader());
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void close() throws Exception {
        this.connectionFactory.stop();
    }

    @Override
    public Iterator<MarshalledEntry> iterator() {
        switch (this.config.storeType) {
            case BINARY: {
                return new BinaryJdbcIterator(this.connectionFactory, this.getTableManager(true), this.marshaller);
            }
            case STRING: {
                return new StringJdbcIterator(this.connectionFactory, this.getTableManager(false), this.marshaller, this.config.getKey2StringMapper());
            }
            case MIXED: {
                return new MixedJdbcIterator(this.connectionFactory, this.getTableManager(true), this.getTableManager(false), this.marshaller, this.config.getKey2StringMapper());
            }
        }
        throw new IllegalArgumentException("Unknown Store Type: " + (Object)((Object)this.config.storeType));
    }

    private TableManager getTableManager(boolean binary) {
        TableManipulationConfiguration tableConfig = binary ? this.config.getBinaryTable() : this.config.getStringTable();
        TableManager tableManager = TableManagerFactory.getManager((DbMetaData)this.config.getDbMeta(), (ConnectionFactory)this.connectionFactory, (TableManipulationConfiguration)tableConfig);
        tableManager.setCacheName(this.config.cacheName);
        return tableManager;
    }
}

