/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.config.v6.jpa;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.tools.config.v6.Parser60;
import org.infinispan.tools.config.v6.jpa.Attribute;
import org.infinispan.tools.config.v6.jpa.Element;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:jpa:6.0", root="jpaStore")})
public class JpaStoreConfigurationParser60
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case JPA_STORE: {
                ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
                this.parseJpaCacheStore(reader, (JpaStoreConfigurationBuilder)builder.persistence().addStore(JpaStoreConfigurationBuilder.class), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseJpaCacheStore(XMLExtendedStreamReader reader, JpaStoreConfigurationBuilder builder, ClassLoader classLoader) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENTITY_CLASS_NAME: {
                    Class clazz = Util.loadClass((String)value, (ClassLoader)classLoader);
                    builder.entityClass(clazz);
                    continue block6;
                }
                case BATCH_SIZE: {
                    builder.batchSize(Long.valueOf(value).longValue());
                    continue block6;
                }
                case PERSISTENCE_UNIT_NAME: {
                    builder.persistenceUnitName(value);
                    continue block6;
                }
                case STORE_METADATA: {
                    builder.storeMetadata(Boolean.valueOf(value).booleanValue());
                    continue block6;
                }
                default: {
                    Parser60.parseCommonStoreAttributes(reader, (StoreConfigurationBuilder)builder, reader.getAttributeLocalName(i), value, i);
                }
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

